/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.BridgePlacement;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGatewayInstanceResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, UpdateGatewayInstanceResponse> {
    private static final SdkField<String> BRIDGE_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgePlacement").getter(UpdateGatewayInstanceResponse.getter(UpdateGatewayInstanceResponse::bridgePlacementAsString)).setter(UpdateGatewayInstanceResponse.setter(Builder::bridgePlacement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgePlacement").build()}).build();
    private static final SdkField<String> GATEWAY_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayInstanceArn").getter(UpdateGatewayInstanceResponse.getter(UpdateGatewayInstanceResponse::gatewayInstanceArn)).setter(UpdateGatewayInstanceResponse.setter(Builder::gatewayInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayInstanceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_PLACEMENT_FIELD, GATEWAY_INSTANCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateGatewayInstanceResponse.memberNameToFieldInitializer();
    private final String bridgePlacement;
    private final String gatewayInstanceArn;

    private UpdateGatewayInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.bridgePlacement = builder.bridgePlacement;
        this.gatewayInstanceArn = builder.gatewayInstanceArn;
    }

    public final BridgePlacement bridgePlacement() {
        return BridgePlacement.fromValue(this.bridgePlacement);
    }

    public final String bridgePlacementAsString() {
        return this.bridgePlacement;
    }

    public final String gatewayInstanceArn() {
        return this.gatewayInstanceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgePlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayInstanceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGatewayInstanceResponse)) {
            return false;
        }
        UpdateGatewayInstanceResponse other = (UpdateGatewayInstanceResponse)((Object)obj);
        return Objects.equals(this.bridgePlacementAsString(), other.bridgePlacementAsString()) && Objects.equals(this.gatewayInstanceArn(), other.gatewayInstanceArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGatewayInstanceResponse").add("BridgePlacement", (Object)this.bridgePlacementAsString()).add("GatewayInstanceArn", (Object)this.gatewayInstanceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BridgePlacement": {
                return Optional.ofNullable(clazz.cast(this.bridgePlacementAsString()));
            }
            case "GatewayInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayInstanceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("bridgePlacement", BRIDGE_PLACEMENT_FIELD);
        map.put("gatewayInstanceArn", GATEWAY_INSTANCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGatewayInstanceResponse, T> g) {
        return obj -> g.apply((UpdateGatewayInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String bridgePlacement;
        private String gatewayInstanceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGatewayInstanceResponse model) {
            super(model);
            this.bridgePlacement(model.bridgePlacement);
            this.gatewayInstanceArn(model.gatewayInstanceArn);
        }

        public final String getBridgePlacement() {
            return this.bridgePlacement;
        }

        public final void setBridgePlacement(String bridgePlacement) {
            this.bridgePlacement = bridgePlacement;
        }

        @Override
        public final Builder bridgePlacement(String bridgePlacement) {
            this.bridgePlacement = bridgePlacement;
            return this;
        }

        @Override
        public final Builder bridgePlacement(BridgePlacement bridgePlacement) {
            this.bridgePlacement(bridgePlacement == null ? null : bridgePlacement.toString());
            return this;
        }

        public final String getGatewayInstanceArn() {
            return this.gatewayInstanceArn;
        }

        public final void setGatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
        }

        @Override
        public final Builder gatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
            return this;
        }

        @Override
        public UpdateGatewayInstanceResponse build() {
            return new UpdateGatewayInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGatewayInstanceResponse> {
        public Builder bridgePlacement(String var1);

        public Builder bridgePlacement(BridgePlacement var1);

        public Builder gatewayInstanceArn(String var1);
    }
}

