/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseOfferingRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, PurchaseOfferingRequest> {
    private static final SdkField<String> OFFERING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingArn").getter(PurchaseOfferingRequest.getter(PurchaseOfferingRequest::offeringArn)).setter(PurchaseOfferingRequest.setter(Builder::offeringArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("OfferingArn").build()}).build();
    private static final SdkField<String> RESERVATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationName").getter(PurchaseOfferingRequest.getter(PurchaseOfferingRequest::reservationName)).setter(PurchaseOfferingRequest.setter(Builder::reservationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationName").build()}).build();
    private static final SdkField<String> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Start").getter(PurchaseOfferingRequest.getter(PurchaseOfferingRequest::start)).setter(PurchaseOfferingRequest.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_ARN_FIELD, RESERVATION_NAME_FIELD, START_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PurchaseOfferingRequest.memberNameToFieldInitializer();
    private final String offeringArn;
    private final String reservationName;
    private final String start;

    private PurchaseOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.offeringArn = builder.offeringArn;
        this.reservationName = builder.reservationName;
        this.start = builder.start;
    }

    public final String offeringArn() {
        return this.offeringArn;
    }

    public final String reservationName() {
        return this.reservationName;
    }

    public final String start() {
        return this.start;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseOfferingRequest)) {
            return false;
        }
        PurchaseOfferingRequest other = (PurchaseOfferingRequest)((Object)obj);
        return Objects.equals(this.offeringArn(), other.offeringArn()) && Objects.equals(this.reservationName(), other.reservationName()) && Objects.equals(this.start(), other.start());
    }

    public final String toString() {
        return ToString.builder((String)"PurchaseOfferingRequest").add("OfferingArn", (Object)this.offeringArn()).add("ReservationName", (Object)this.reservationName()).add("Start", (Object)this.start()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OfferingArn": {
                return Optional.ofNullable(clazz.cast(this.offeringArn()));
            }
            case "ReservationName": {
                return Optional.ofNullable(clazz.cast(this.reservationName()));
            }
            case "Start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("OfferingArn", OFFERING_ARN_FIELD);
        map.put("reservationName", RESERVATION_NAME_FIELD);
        map.put("start", START_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PurchaseOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseOfferingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private String offeringArn;
        private String reservationName;
        private String start;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseOfferingRequest model) {
            super(model);
            this.offeringArn(model.offeringArn);
            this.reservationName(model.reservationName);
            this.start(model.start);
        }

        public final String getOfferingArn() {
            return this.offeringArn;
        }

        public final void setOfferingArn(String offeringArn) {
            this.offeringArn = offeringArn;
        }

        @Override
        public final Builder offeringArn(String offeringArn) {
            this.offeringArn = offeringArn;
            return this;
        }

        public final String getReservationName() {
            return this.reservationName;
        }

        public final void setReservationName(String reservationName) {
            this.reservationName = reservationName;
        }

        @Override
        public final Builder reservationName(String reservationName) {
            this.reservationName = reservationName;
            return this;
        }

        public final String getStart() {
            return this.start;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseOfferingRequest build() {
            return new PurchaseOfferingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseOfferingRequest> {
        public Builder offeringArn(String var1);

        public Builder reservationName(String var1);

        public Builder start(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

