/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveBridgeOutputResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, RemoveBridgeOutputResponse> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgeArn").getter(RemoveBridgeOutputResponse.getter(RemoveBridgeOutputResponse::bridgeArn)).setter(RemoveBridgeOutputResponse.setter(Builder::bridgeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeArn").build()}).build();
    private static final SdkField<String> OUTPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputName").getter(RemoveBridgeOutputResponse.getter(RemoveBridgeOutputResponse::outputName)).setter(RemoveBridgeOutputResponse.setter(Builder::outputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD, OUTPUT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RemoveBridgeOutputResponse.memberNameToFieldInitializer();
    private final String bridgeArn;
    private final String outputName;

    private RemoveBridgeOutputResponse(BuilderImpl builder) {
        super(builder);
        this.bridgeArn = builder.bridgeArn;
        this.outputName = builder.outputName;
    }

    public final String bridgeArn() {
        return this.bridgeArn;
    }

    public final String outputName() {
        return this.outputName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveBridgeOutputResponse)) {
            return false;
        }
        RemoveBridgeOutputResponse other = (RemoveBridgeOutputResponse)((Object)obj);
        return Objects.equals(this.bridgeArn(), other.bridgeArn()) && Objects.equals(this.outputName(), other.outputName());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveBridgeOutputResponse").add("BridgeArn", (Object)this.bridgeArn()).add("OutputName", (Object)this.outputName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BridgeArn": {
                return Optional.ofNullable(clazz.cast(this.bridgeArn()));
            }
            case "OutputName": {
                return Optional.ofNullable(clazz.cast(this.outputName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("bridgeArn", BRIDGE_ARN_FIELD);
        map.put("outputName", OUTPUT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoveBridgeOutputResponse, T> g) {
        return obj -> g.apply((RemoveBridgeOutputResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String bridgeArn;
        private String outputName;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveBridgeOutputResponse model) {
            super(model);
            this.bridgeArn(model.bridgeArn);
            this.outputName(model.outputName);
        }

        public final String getBridgeArn() {
            return this.bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final String getOutputName() {
            return this.outputName;
        }

        public final void setOutputName(String outputName) {
            this.outputName = outputName;
        }

        @Override
        public final Builder outputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        @Override
        public RemoveBridgeOutputResponse build() {
            return new RemoveBridgeOutputResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveBridgeOutputResponse> {
        public Builder bridgeArn(String var1);

        public Builder outputName(String var1);
    }
}

