/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.ListedBridge;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.___listOfListedBridgeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBridgesResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, ListBridgesResponse> {
    private static final SdkField<List<ListedBridge>> BRIDGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Bridges").getter(ListBridgesResponse.getter(ListBridgesResponse::bridges)).setter(ListBridgesResponse.setter(Builder::bridges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListedBridge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBridgesResponse.getter(ListBridgesResponse::nextToken)).setter(ListBridgesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("bridges", BRIDGES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ListedBridge> bridges;
    private final String nextToken;

    private ListBridgesResponse(BuilderImpl builder) {
        super(builder);
        this.bridges = builder.bridges;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBridges() {
        return this.bridges != null && !(this.bridges instanceof SdkAutoConstructList);
    }

    public final List<ListedBridge> bridges() {
        return this.bridges;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBridges() ? this.bridges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBridgesResponse)) {
            return false;
        }
        ListBridgesResponse other = (ListBridgesResponse)((Object)obj);
        return this.hasBridges() == other.hasBridges() && Objects.equals(this.bridges(), other.bridges()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBridgesResponse").add("Bridges", this.hasBridges() ? this.bridges() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bridges": {
                return Optional.ofNullable(clazz.cast(this.bridges()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListBridgesResponse, T> g) {
        return obj -> g.apply((ListBridgesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private List<ListedBridge> bridges = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBridgesResponse model) {
            super(model);
            this.bridges(model.bridges);
            this.nextToken(model.nextToken);
        }

        public final List<ListedBridge.Builder> getBridges() {
            List<ListedBridge.Builder> result = ___listOfListedBridgeCopier.copyToBuilder(this.bridges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBridges(Collection<ListedBridge.BuilderImpl> bridges) {
            this.bridges = ___listOfListedBridgeCopier.copyFromBuilder(bridges);
        }

        @Override
        public final Builder bridges(Collection<ListedBridge> bridges) {
            this.bridges = ___listOfListedBridgeCopier.copy(bridges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bridges(ListedBridge ... bridges) {
            this.bridges(Arrays.asList(bridges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bridges(Consumer<ListedBridge.Builder> ... bridges) {
            this.bridges(Stream.of(bridges).map(c -> (ListedBridge)((ListedBridge.Builder)ListedBridge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBridgesResponse build() {
            return new ListBridgesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBridgesResponse> {
        public Builder bridges(Collection<ListedBridge> var1);

        public Builder bridges(ListedBridge ... var1);

        public Builder bridges(Consumer<ListedBridge.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

