/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for a gateway, including its networks.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Gateway implements SdkPojo, Serializable, ToCopyableBuilder<Gateway.Builder, Gateway> {
    private static final SdkField<List<String>> EGRESS_CIDR_BLOCKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EgressCidrBlocks")
            .getter(getter(Gateway::egressCidrBlocks))
            .setter(setter(Builder::egressCidrBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressCidrBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayArn").getter(getter(Gateway::gatewayArn)).setter(setter(Builder::gatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayArn").build()).build();

    private static final SdkField<List<MessageDetail>> GATEWAY_MESSAGES_FIELD = SdkField
            .<List<MessageDetail>> builder(MarshallingType.LIST)
            .memberName("GatewayMessages")
            .getter(getter(Gateway::gatewayMessages))
            .setter(setter(Builder::gatewayMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GATEWAY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayState").getter(getter(Gateway::gatewayStateAsString)).setter(setter(Builder::gatewayState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayState").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Gateway::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<GatewayNetwork>> NETWORKS_FIELD = SdkField
            .<List<GatewayNetwork>> builder(MarshallingType.LIST)
            .memberName("Networks")
            .getter(getter(Gateway::networks))
            .setter(setter(Builder::networks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GatewayNetwork> builder(MarshallingType.SDK_POJO)
                                            .constructor(GatewayNetwork::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_CIDR_BLOCKS_FIELD,
            GATEWAY_ARN_FIELD, GATEWAY_MESSAGES_FIELD, GATEWAY_STATE_FIELD, NAME_FIELD, NETWORKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> egressCidrBlocks;

    private final String gatewayArn;

    private final List<MessageDetail> gatewayMessages;

    private final String gatewayState;

    private final String name;

    private final List<GatewayNetwork> networks;

    private Gateway(BuilderImpl builder) {
        this.egressCidrBlocks = builder.egressCidrBlocks;
        this.gatewayArn = builder.gatewayArn;
        this.gatewayMessages = builder.gatewayMessages;
        this.gatewayState = builder.gatewayState;
        this.name = builder.name;
        this.networks = builder.networks;
    }

    /**
     * For responses, this returns true if the service returned a value for the EgressCidrBlocks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEgressCidrBlocks() {
        return egressCidrBlocks != null && !(egressCidrBlocks instanceof SdkAutoConstructList);
    }

    /**
     * The range of IP addresses that contribute content or initiate output requests for flows communicating with this
     * gateway. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
     * 10.0.0.0/16.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEgressCidrBlocks} method.
     * </p>
     * 
     * @return The range of IP addresses that contribute content or initiate output requests for flows communicating
     *         with this gateway. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR)
     *         block; for example, 10.0.0.0/16.
     */
    public final List<String> egressCidrBlocks() {
        return egressCidrBlocks;
    }

    /**
     * The Amazon Resource Name (ARN) of the gateway.
     * 
     * @return The Amazon Resource Name (ARN) of the gateway.
     */
    public final String gatewayArn() {
        return gatewayArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the GatewayMessages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGatewayMessages() {
        return gatewayMessages != null && !(gatewayMessages instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the GatewayMessages property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGatewayMessages} method.
     * </p>
     * 
     * @return The value of the GatewayMessages property for this object.
     */
    public final List<MessageDetail> gatewayMessages() {
        return gatewayMessages;
    }

    /**
     * The current status of the gateway.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gatewayState} will
     * return {@link GatewayState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gatewayStateAsString}.
     * </p>
     * 
     * @return The current status of the gateway.
     * @see GatewayState
     */
    public final GatewayState gatewayState() {
        return GatewayState.fromValue(gatewayState);
    }

    /**
     * The current status of the gateway.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gatewayState} will
     * return {@link GatewayState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gatewayStateAsString}.
     * </p>
     * 
     * @return The current status of the gateway.
     * @see GatewayState
     */
    public final String gatewayStateAsString() {
        return gatewayState;
    }

    /**
     * The name of the gateway. This name can not be modified after the gateway is created.
     * 
     * @return The name of the gateway. This name can not be modified after the gateway is created.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Networks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNetworks() {
        return networks != null && !(networks instanceof SdkAutoConstructList);
    }

    /**
     * The list of networks in the gateway.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworks} method.
     * </p>
     * 
     * @return The list of networks in the gateway.
     */
    public final List<GatewayNetwork> networks() {
        return networks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEgressCidrBlocks() ? egressCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasGatewayMessages() ? gatewayMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(gatewayStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworks() ? networks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Gateway)) {
            return false;
        }
        Gateway other = (Gateway) obj;
        return hasEgressCidrBlocks() == other.hasEgressCidrBlocks()
                && Objects.equals(egressCidrBlocks(), other.egressCidrBlocks())
                && Objects.equals(gatewayArn(), other.gatewayArn()) && hasGatewayMessages() == other.hasGatewayMessages()
                && Objects.equals(gatewayMessages(), other.gatewayMessages())
                && Objects.equals(gatewayStateAsString(), other.gatewayStateAsString()) && Objects.equals(name(), other.name())
                && hasNetworks() == other.hasNetworks() && Objects.equals(networks(), other.networks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Gateway").add("EgressCidrBlocks", hasEgressCidrBlocks() ? egressCidrBlocks() : null)
                .add("GatewayArn", gatewayArn()).add("GatewayMessages", hasGatewayMessages() ? gatewayMessages() : null)
                .add("GatewayState", gatewayStateAsString()).add("Name", name())
                .add("Networks", hasNetworks() ? networks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EgressCidrBlocks":
            return Optional.ofNullable(clazz.cast(egressCidrBlocks()));
        case "GatewayArn":
            return Optional.ofNullable(clazz.cast(gatewayArn()));
        case "GatewayMessages":
            return Optional.ofNullable(clazz.cast(gatewayMessages()));
        case "GatewayState":
            return Optional.ofNullable(clazz.cast(gatewayStateAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Networks":
            return Optional.ofNullable(clazz.cast(networks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Gateway, T> g) {
        return obj -> g.apply((Gateway) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Gateway> {
        /**
         * The range of IP addresses that contribute content or initiate output requests for flows communicating with
         * this gateway. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for
         * example, 10.0.0.0/16.
         * 
         * @param egressCidrBlocks
         *        The range of IP addresses that contribute content or initiate output requests for flows communicating
         *        with this gateway. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR)
         *        block; for example, 10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressCidrBlocks(Collection<String> egressCidrBlocks);

        /**
         * The range of IP addresses that contribute content or initiate output requests for flows communicating with
         * this gateway. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for
         * example, 10.0.0.0/16.
         * 
         * @param egressCidrBlocks
         *        The range of IP addresses that contribute content or initiate output requests for flows communicating
         *        with this gateway. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR)
         *        block; for example, 10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressCidrBlocks(String... egressCidrBlocks);

        /**
         * The Amazon Resource Name (ARN) of the gateway.
         * 
         * @param gatewayArn
         *        The Amazon Resource Name (ARN) of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayArn(String gatewayArn);

        /**
         * Sets the value of the GatewayMessages property for this object.
         *
         * @param gatewayMessages
         *        The new value for the GatewayMessages property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayMessages(Collection<MessageDetail> gatewayMessages);

        /**
         * Sets the value of the GatewayMessages property for this object.
         *
         * @param gatewayMessages
         *        The new value for the GatewayMessages property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayMessages(MessageDetail... gatewayMessages);

        /**
         * Sets the value of the GatewayMessages property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #gatewayMessages(List<MessageDetail>)}.
         * 
         * @param gatewayMessages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatewayMessages(java.util.Collection<MessageDetail>)
         */
        Builder gatewayMessages(Consumer<MessageDetail.Builder>... gatewayMessages);

        /**
         * The current status of the gateway.
         * 
         * @param gatewayState
         *        The current status of the gateway.
         * @see GatewayState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayState
         */
        Builder gatewayState(String gatewayState);

        /**
         * The current status of the gateway.
         * 
         * @param gatewayState
         *        The current status of the gateway.
         * @see GatewayState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayState
         */
        Builder gatewayState(GatewayState gatewayState);

        /**
         * The name of the gateway. This name can not be modified after the gateway is created.
         * 
         * @param name
         *        The name of the gateway. This name can not be modified after the gateway is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The list of networks in the gateway.
         * 
         * @param networks
         *        The list of networks in the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networks(Collection<GatewayNetwork> networks);

        /**
         * The list of networks in the gateway.
         * 
         * @param networks
         *        The list of networks in the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networks(GatewayNetwork... networks);

        /**
         * The list of networks in the gateway. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.GatewayNetwork.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediaconnect.model.GatewayNetwork#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.GatewayNetwork.Builder#build()} is called
         * immediately and its result is passed to {@link #networks(List<GatewayNetwork>)}.
         * 
         * @param networks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.GatewayNetwork.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networks(java.util.Collection<GatewayNetwork>)
         */
        Builder networks(Consumer<GatewayNetwork.Builder>... networks);
    }

    static final class BuilderImpl implements Builder {
        private List<String> egressCidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private String gatewayArn;

        private List<MessageDetail> gatewayMessages = DefaultSdkAutoConstructList.getInstance();

        private String gatewayState;

        private String name;

        private List<GatewayNetwork> networks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Gateway model) {
            egressCidrBlocks(model.egressCidrBlocks);
            gatewayArn(model.gatewayArn);
            gatewayMessages(model.gatewayMessages);
            gatewayState(model.gatewayState);
            name(model.name);
            networks(model.networks);
        }

        public final Collection<String> getEgressCidrBlocks() {
            if (egressCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return egressCidrBlocks;
        }

        public final void setEgressCidrBlocks(Collection<String> egressCidrBlocks) {
            this.egressCidrBlocks = ___listOf__stringCopier.copy(egressCidrBlocks);
        }

        @Override
        public final Builder egressCidrBlocks(Collection<String> egressCidrBlocks) {
            this.egressCidrBlocks = ___listOf__stringCopier.copy(egressCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressCidrBlocks(String... egressCidrBlocks) {
            egressCidrBlocks(Arrays.asList(egressCidrBlocks));
            return this;
        }

        public final String getGatewayArn() {
            return gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final List<MessageDetail.Builder> getGatewayMessages() {
            List<MessageDetail.Builder> result = ___listOfMessageDetailCopier.copyToBuilder(this.gatewayMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGatewayMessages(Collection<MessageDetail.BuilderImpl> gatewayMessages) {
            this.gatewayMessages = ___listOfMessageDetailCopier.copyFromBuilder(gatewayMessages);
        }

        @Override
        public final Builder gatewayMessages(Collection<MessageDetail> gatewayMessages) {
            this.gatewayMessages = ___listOfMessageDetailCopier.copy(gatewayMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayMessages(MessageDetail... gatewayMessages) {
            gatewayMessages(Arrays.asList(gatewayMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayMessages(Consumer<MessageDetail.Builder>... gatewayMessages) {
            gatewayMessages(Stream.of(gatewayMessages).map(c -> MessageDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getGatewayState() {
            return gatewayState;
        }

        public final void setGatewayState(String gatewayState) {
            this.gatewayState = gatewayState;
        }

        @Override
        public final Builder gatewayState(String gatewayState) {
            this.gatewayState = gatewayState;
            return this;
        }

        @Override
        public final Builder gatewayState(GatewayState gatewayState) {
            this.gatewayState(gatewayState == null ? null : gatewayState.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<GatewayNetwork.Builder> getNetworks() {
            List<GatewayNetwork.Builder> result = ___listOfGatewayNetworkCopier.copyToBuilder(this.networks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworks(Collection<GatewayNetwork.BuilderImpl> networks) {
            this.networks = ___listOfGatewayNetworkCopier.copyFromBuilder(networks);
        }

        @Override
        public final Builder networks(Collection<GatewayNetwork> networks) {
            this.networks = ___listOfGatewayNetworkCopier.copy(networks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(GatewayNetwork... networks) {
            networks(Arrays.asList(networks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(Consumer<GatewayNetwork.Builder>... networks) {
            networks(Stream.of(networks).map(c -> GatewayNetwork.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Gateway build() {
            return new Gateway(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
