/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.GatewayNetwork;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.___listOfGatewayNetworkCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGatewayRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, CreateGatewayRequest> {
    private static final SdkField<List<String>> EGRESS_CIDR_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EgressCidrBlocks").getter(CreateGatewayRequest.getter(CreateGatewayRequest::egressCidrBlocks)).setter(CreateGatewayRequest.setter(Builder::egressCidrBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressCidrBlocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateGatewayRequest.getter(CreateGatewayRequest::name)).setter(CreateGatewayRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<GatewayNetwork>> NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Networks").getter(CreateGatewayRequest.getter(CreateGatewayRequest::networks)).setter(CreateGatewayRequest.setter(Builder::networks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GatewayNetwork::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_CIDR_BLOCKS_FIELD, NAME_FIELD, NETWORKS_FIELD));
    private final List<String> egressCidrBlocks;
    private final String name;
    private final List<GatewayNetwork> networks;

    private CreateGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.egressCidrBlocks = builder.egressCidrBlocks;
        this.name = builder.name;
        this.networks = builder.networks;
    }

    public final boolean hasEgressCidrBlocks() {
        return this.egressCidrBlocks != null && !(this.egressCidrBlocks instanceof SdkAutoConstructList);
    }

    public final List<String> egressCidrBlocks() {
        return this.egressCidrBlocks;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasNetworks() {
        return this.networks != null && !(this.networks instanceof SdkAutoConstructList);
    }

    public final List<GatewayNetwork> networks() {
        return this.networks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEgressCidrBlocks() ? this.egressCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworks() ? this.networks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGatewayRequest)) {
            return false;
        }
        CreateGatewayRequest other = (CreateGatewayRequest)((Object)obj);
        return this.hasEgressCidrBlocks() == other.hasEgressCidrBlocks() && Objects.equals(this.egressCidrBlocks(), other.egressCidrBlocks()) && Objects.equals(this.name(), other.name()) && this.hasNetworks() == other.hasNetworks() && Objects.equals(this.networks(), other.networks());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGatewayRequest").add("EgressCidrBlocks", this.hasEgressCidrBlocks() ? this.egressCidrBlocks() : null).add("Name", (Object)this.name()).add("Networks", this.hasNetworks() ? this.networks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EgressCidrBlocks": {
                return Optional.ofNullable(clazz.cast(this.egressCidrBlocks()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Networks": {
                return Optional.ofNullable(clazz.cast(this.networks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGatewayRequest, T> g) {
        return obj -> g.apply((CreateGatewayRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private List<String> egressCidrBlocks = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private List<GatewayNetwork> networks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGatewayRequest model) {
            super(model);
            this.egressCidrBlocks(model.egressCidrBlocks);
            this.name(model.name);
            this.networks(model.networks);
        }

        public final Collection<String> getEgressCidrBlocks() {
            if (this.egressCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.egressCidrBlocks;
        }

        public final void setEgressCidrBlocks(Collection<String> egressCidrBlocks) {
            this.egressCidrBlocks = ___listOf__stringCopier.copy(egressCidrBlocks);
        }

        @Override
        public final Builder egressCidrBlocks(Collection<String> egressCidrBlocks) {
            this.egressCidrBlocks = ___listOf__stringCopier.copy(egressCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressCidrBlocks(String ... egressCidrBlocks) {
            this.egressCidrBlocks(Arrays.asList(egressCidrBlocks));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<GatewayNetwork.Builder> getNetworks() {
            List<GatewayNetwork.Builder> result = ___listOfGatewayNetworkCopier.copyToBuilder(this.networks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworks(Collection<GatewayNetwork.BuilderImpl> networks) {
            this.networks = ___listOfGatewayNetworkCopier.copyFromBuilder(networks);
        }

        @Override
        public final Builder networks(Collection<GatewayNetwork> networks) {
            this.networks = ___listOfGatewayNetworkCopier.copy(networks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(GatewayNetwork ... networks) {
            this.networks(Arrays.asList(networks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(Consumer<GatewayNetwork.Builder> ... networks) {
            this.networks(Stream.of(networks).map(c -> (GatewayNetwork)((GatewayNetwork.Builder)GatewayNetwork.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGatewayRequest build() {
            return new CreateGatewayRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGatewayRequest> {
        public Builder egressCidrBlocks(Collection<String> var1);

        public Builder egressCidrBlocks(String ... var1);

        public Builder name(String var1);

        public Builder networks(Collection<GatewayNetwork> var1);

        public Builder networks(GatewayNetwork ... var1);

        public Builder networks(Consumer<GatewayNetwork.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

