/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EncodingName {
    JXSV("jxsv"),
    RAW("raw"),
    SMPTE291("smpte291"),
    PCM("pcm"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EncodingName> VALUE_MAP;
    private final String value;

    private EncodingName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncodingName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncodingName> knownValues() {
        EnumSet<EncodingName> knownValues = EnumSet.allOf(EncodingName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EncodingName.class, EncodingName::toString);
    }
}

