/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaStreamAttributesRequest;
import software.amazon.awssdk.services.mediaconnect.model.MediaStreamType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddMediaStreamRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddMediaStreamRequest> {
    private static final SdkField<MediaStreamAttributesRequest> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attributes").getter(AddMediaStreamRequest.getter(AddMediaStreamRequest::attributes)).setter(AddMediaStreamRequest.setter(Builder::attributes)).constructor(MediaStreamAttributesRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()}).build();
    private static final SdkField<Integer> CLOCK_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ClockRate").getter(AddMediaStreamRequest.getter(AddMediaStreamRequest::clockRate)).setter(AddMediaStreamRequest.setter(Builder::clockRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clockRate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AddMediaStreamRequest.getter(AddMediaStreamRequest::description)).setter(AddMediaStreamRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Integer> MEDIA_STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MediaStreamId").getter(AddMediaStreamRequest.getter(AddMediaStreamRequest::mediaStreamId)).setter(AddMediaStreamRequest.setter(Builder::mediaStreamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamId").build()}).build();
    private static final SdkField<String> MEDIA_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaStreamName").getter(AddMediaStreamRequest.getter(AddMediaStreamRequest::mediaStreamName)).setter(AddMediaStreamRequest.setter(Builder::mediaStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamName").build()}).build();
    private static final SdkField<String> MEDIA_STREAM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaStreamType").getter(AddMediaStreamRequest.getter(AddMediaStreamRequest::mediaStreamTypeAsString)).setter(AddMediaStreamRequest.setter(Builder::mediaStreamType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamType").build()}).build();
    private static final SdkField<String> VIDEO_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VideoFormat").getter(AddMediaStreamRequest.getter(AddMediaStreamRequest::videoFormat)).setter(AddMediaStreamRequest.setter(Builder::videoFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, CLOCK_RATE_FIELD, DESCRIPTION_FIELD, MEDIA_STREAM_ID_FIELD, MEDIA_STREAM_NAME_FIELD, MEDIA_STREAM_TYPE_FIELD, VIDEO_FORMAT_FIELD));
    private static final long serialVersionUID = 1L;
    private final MediaStreamAttributesRequest attributes;
    private final Integer clockRate;
    private final String description;
    private final Integer mediaStreamId;
    private final String mediaStreamName;
    private final String mediaStreamType;
    private final String videoFormat;

    private AddMediaStreamRequest(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.clockRate = builder.clockRate;
        this.description = builder.description;
        this.mediaStreamId = builder.mediaStreamId;
        this.mediaStreamName = builder.mediaStreamName;
        this.mediaStreamType = builder.mediaStreamType;
        this.videoFormat = builder.videoFormat;
    }

    public final MediaStreamAttributesRequest attributes() {
        return this.attributes;
    }

    public final Integer clockRate() {
        return this.clockRate;
    }

    public final String description() {
        return this.description;
    }

    public final Integer mediaStreamId() {
        return this.mediaStreamId;
    }

    public final String mediaStreamName() {
        return this.mediaStreamName;
    }

    public final MediaStreamType mediaStreamType() {
        return MediaStreamType.fromValue(this.mediaStreamType);
    }

    public final String mediaStreamTypeAsString() {
        return this.mediaStreamType;
    }

    public final String videoFormat() {
        return this.videoFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.clockRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaStreamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaStreamTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoFormat());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddMediaStreamRequest)) {
            return false;
        }
        AddMediaStreamRequest other = (AddMediaStreamRequest)obj;
        return Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.clockRate(), other.clockRate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.mediaStreamId(), other.mediaStreamId()) && Objects.equals(this.mediaStreamName(), other.mediaStreamName()) && Objects.equals(this.mediaStreamTypeAsString(), other.mediaStreamTypeAsString()) && Objects.equals(this.videoFormat(), other.videoFormat());
    }

    public final String toString() {
        return ToString.builder((String)"AddMediaStreamRequest").add("Attributes", (Object)this.attributes()).add("ClockRate", (Object)this.clockRate()).add("Description", (Object)this.description()).add("MediaStreamId", (Object)this.mediaStreamId()).add("MediaStreamName", (Object)this.mediaStreamName()).add("MediaStreamType", (Object)this.mediaStreamTypeAsString()).add("VideoFormat", (Object)this.videoFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "ClockRate": {
                return Optional.ofNullable(clazz.cast(this.clockRate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "MediaStreamId": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamId()));
            }
            case "MediaStreamName": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamName()));
            }
            case "MediaStreamType": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamTypeAsString()));
            }
            case "VideoFormat": {
                return Optional.ofNullable(clazz.cast(this.videoFormat()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddMediaStreamRequest, T> g) {
        return obj -> g.apply((AddMediaStreamRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MediaStreamAttributesRequest attributes;
        private Integer clockRate;
        private String description;
        private Integer mediaStreamId;
        private String mediaStreamName;
        private String mediaStreamType;
        private String videoFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(AddMediaStreamRequest model) {
            this.attributes(model.attributes);
            this.clockRate(model.clockRate);
            this.description(model.description);
            this.mediaStreamId(model.mediaStreamId);
            this.mediaStreamName(model.mediaStreamName);
            this.mediaStreamType(model.mediaStreamType);
            this.videoFormat(model.videoFormat);
        }

        public final MediaStreamAttributesRequest.Builder getAttributes() {
            return this.attributes != null ? this.attributes.toBuilder() : null;
        }

        public final void setAttributes(MediaStreamAttributesRequest.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        @Transient
        public final Builder attributes(MediaStreamAttributesRequest attributes) {
            this.attributes = attributes;
            return this;
        }

        public final Integer getClockRate() {
            return this.clockRate;
        }

        public final void setClockRate(Integer clockRate) {
            this.clockRate = clockRate;
        }

        @Override
        @Transient
        public final Builder clockRate(Integer clockRate) {
            this.clockRate = clockRate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getMediaStreamId() {
            return this.mediaStreamId;
        }

        public final void setMediaStreamId(Integer mediaStreamId) {
            this.mediaStreamId = mediaStreamId;
        }

        @Override
        @Transient
        public final Builder mediaStreamId(Integer mediaStreamId) {
            this.mediaStreamId = mediaStreamId;
            return this;
        }

        public final String getMediaStreamName() {
            return this.mediaStreamName;
        }

        public final void setMediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
        }

        @Override
        @Transient
        public final Builder mediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
            return this;
        }

        public final String getMediaStreamType() {
            return this.mediaStreamType;
        }

        public final void setMediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
        }

        @Override
        @Transient
        public final Builder mediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
            return this;
        }

        @Override
        @Transient
        public final Builder mediaStreamType(MediaStreamType mediaStreamType) {
            this.mediaStreamType(mediaStreamType == null ? null : mediaStreamType.toString());
            return this;
        }

        public final String getVideoFormat() {
            return this.videoFormat;
        }

        public final void setVideoFormat(String videoFormat) {
            this.videoFormat = videoFormat;
        }

        @Override
        @Transient
        public final Builder videoFormat(String videoFormat) {
            this.videoFormat = videoFormat;
            return this;
        }

        public AddMediaStreamRequest build() {
            return new AddMediaStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddMediaStreamRequest> {
        public Builder attributes(MediaStreamAttributesRequest var1);

        default public Builder attributes(Consumer<MediaStreamAttributesRequest.Builder> attributes) {
            return this.attributes((MediaStreamAttributesRequest)((MediaStreamAttributesRequest.Builder)MediaStreamAttributesRequest.builder().applyMutation(attributes)).build());
        }

        public Builder clockRate(Integer var1);

        public Builder description(String var1);

        public Builder mediaStreamId(Integer var1);

        public Builder mediaStreamName(String var1);

        public Builder mediaStreamType(String var1);

        public Builder mediaStreamType(MediaStreamType var1);

        public Builder videoFormat(String var1);
    }
}

