/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.Entitlement;
import software.amazon.awssdk.services.mediaconnect.model.FailoverConfig;
import software.amazon.awssdk.services.mediaconnect.model.MediaStream;
import software.amazon.awssdk.services.mediaconnect.model.Output;
import software.amazon.awssdk.services.mediaconnect.model.Source;
import software.amazon.awssdk.services.mediaconnect.model.Status;
import software.amazon.awssdk.services.mediaconnect.model.VpcInterface;
import software.amazon.awssdk.services.mediaconnect.model.___listOfEntitlementCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfMediaStreamCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfOutputCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfSourceCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfVpcInterfaceCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Flow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Flow> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(Flow.getter(Flow::availabilityZone)).setter(Flow.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Flow.getter(Flow::description)).setter(Flow.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> EGRESS_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EgressIp").getter(Flow.getter(Flow::egressIp)).setter(Flow.setter(Builder::egressIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressIp").build()}).build();
    private static final SdkField<List<Entitlement>> ENTITLEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entitlements").getter(Flow.getter(Flow::entitlements)).setter(Flow.setter(Builder::entitlements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Entitlement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(Flow.getter(Flow::flowArn)).setter(Flow.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<List<MediaStream>> MEDIA_STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaStreams").getter(Flow.getter(Flow::mediaStreams)).setter(Flow.setter(Builder::mediaStreams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaStream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Flow.getter(Flow::name)).setter(Flow.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(Flow.getter(Flow::outputs)).setter(Flow.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Output::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Source> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(Flow.getter(Flow::source)).setter(Flow.setter(Builder::source)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<FailoverConfig> SOURCE_FAILOVER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceFailoverConfig").getter(Flow.getter(Flow::sourceFailoverConfig)).setter(Flow.setter(Builder::sourceFailoverConfig)).constructor(FailoverConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFailoverConfig").build()}).build();
    private static final SdkField<List<Source>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(Flow.getter(Flow::sources)).setter(Flow.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Flow.getter(Flow::statusAsString)).setter(Flow.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<VpcInterface>> VPC_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcInterfaces").getter(Flow.getter(Flow::vpcInterfaces)).setter(Flow.setter(Builder::vpcInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, DESCRIPTION_FIELD, EGRESS_IP_FIELD, ENTITLEMENTS_FIELD, FLOW_ARN_FIELD, MEDIA_STREAMS_FIELD, NAME_FIELD, OUTPUTS_FIELD, SOURCE_FIELD, SOURCE_FAILOVER_CONFIG_FIELD, SOURCES_FIELD, STATUS_FIELD, VPC_INTERFACES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final String description;
    private final String egressIp;
    private final List<Entitlement> entitlements;
    private final String flowArn;
    private final List<MediaStream> mediaStreams;
    private final String name;
    private final List<Output> outputs;
    private final Source source;
    private final FailoverConfig sourceFailoverConfig;
    private final List<Source> sources;
    private final String status;
    private final List<VpcInterface> vpcInterfaces;

    private Flow(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.description = builder.description;
        this.egressIp = builder.egressIp;
        this.entitlements = builder.entitlements;
        this.flowArn = builder.flowArn;
        this.mediaStreams = builder.mediaStreams;
        this.name = builder.name;
        this.outputs = builder.outputs;
        this.source = builder.source;
        this.sourceFailoverConfig = builder.sourceFailoverConfig;
        this.sources = builder.sources;
        this.status = builder.status;
        this.vpcInterfaces = builder.vpcInterfaces;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String description() {
        return this.description;
    }

    public final String egressIp() {
        return this.egressIp;
    }

    public final boolean hasEntitlements() {
        return this.entitlements != null && !(this.entitlements instanceof SdkAutoConstructList);
    }

    public final List<Entitlement> entitlements() {
        return this.entitlements;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final boolean hasMediaStreams() {
        return this.mediaStreams != null && !(this.mediaStreams instanceof SdkAutoConstructList);
    }

    public final List<MediaStream> mediaStreams() {
        return this.mediaStreams;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<Output> outputs() {
        return this.outputs;
    }

    public final Source source() {
        return this.source;
    }

    public final FailoverConfig sourceFailoverConfig() {
        return this.sourceFailoverConfig;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<Source> sources() {
        return this.sources;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasVpcInterfaces() {
        return this.vpcInterfaces != null && !(this.vpcInterfaces instanceof SdkAutoConstructList);
    }

    public final List<VpcInterface> vpcInterfaces() {
        return this.vpcInterfaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntitlements() ? this.entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaStreams() ? this.mediaStreams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFailoverConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcInterfaces() ? this.vpcInterfaces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.egressIp(), other.egressIp()) && this.hasEntitlements() == other.hasEntitlements() && Objects.equals(this.entitlements(), other.entitlements()) && Objects.equals(this.flowArn(), other.flowArn()) && this.hasMediaStreams() == other.hasMediaStreams() && Objects.equals(this.mediaStreams(), other.mediaStreams()) && Objects.equals(this.name(), other.name()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.sourceFailoverConfig(), other.sourceFailoverConfig()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasVpcInterfaces() == other.hasVpcInterfaces() && Objects.equals(this.vpcInterfaces(), other.vpcInterfaces());
    }

    public final String toString() {
        return ToString.builder((String)"Flow").add("AvailabilityZone", (Object)this.availabilityZone()).add("Description", (Object)this.description()).add("EgressIp", (Object)this.egressIp()).add("Entitlements", this.hasEntitlements() ? this.entitlements() : null).add("FlowArn", (Object)this.flowArn()).add("MediaStreams", this.hasMediaStreams() ? this.mediaStreams() : null).add("Name", (Object)this.name()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("Source", (Object)this.source()).add("SourceFailoverConfig", (Object)this.sourceFailoverConfig()).add("Sources", this.hasSources() ? this.sources() : null).add("Status", (Object)this.statusAsString()).add("VpcInterfaces", this.hasVpcInterfaces() ? this.vpcInterfaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EgressIp": {
                return Optional.ofNullable(clazz.cast(this.egressIp()));
            }
            case "Entitlements": {
                return Optional.ofNullable(clazz.cast(this.entitlements()));
            }
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "MediaStreams": {
                return Optional.ofNullable(clazz.cast(this.mediaStreams()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "SourceFailoverConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceFailoverConfig()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "VpcInterfaces": {
                return Optional.ofNullable(clazz.cast(this.vpcInterfaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Flow, T> g) {
        return obj -> g.apply((Flow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String description;
        private String egressIp;
        private List<Entitlement> entitlements = DefaultSdkAutoConstructList.getInstance();
        private String flowArn;
        private List<MediaStream> mediaStreams = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();
        private Source source;
        private FailoverConfig sourceFailoverConfig;
        private List<Source> sources = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private List<VpcInterface> vpcInterfaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Flow model) {
            this.availabilityZone(model.availabilityZone);
            this.description(model.description);
            this.egressIp(model.egressIp);
            this.entitlements(model.entitlements);
            this.flowArn(model.flowArn);
            this.mediaStreams(model.mediaStreams);
            this.name(model.name);
            this.outputs(model.outputs);
            this.source(model.source);
            this.sourceFailoverConfig(model.sourceFailoverConfig);
            this.sources(model.sources);
            this.status(model.status);
            this.vpcInterfaces(model.vpcInterfaces);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEgressIp() {
            return this.egressIp;
        }

        public final void setEgressIp(String egressIp) {
            this.egressIp = egressIp;
        }

        @Override
        @Transient
        public final Builder egressIp(String egressIp) {
            this.egressIp = egressIp;
            return this;
        }

        public final List<Entitlement.Builder> getEntitlements() {
            List<Entitlement.Builder> result = ___listOfEntitlementCopier.copyToBuilder(this.entitlements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlements(Collection<Entitlement.BuilderImpl> entitlements) {
            this.entitlements = ___listOfEntitlementCopier.copyFromBuilder(entitlements);
        }

        @Override
        @Transient
        public final Builder entitlements(Collection<Entitlement> entitlements) {
            this.entitlements = ___listOfEntitlementCopier.copy(entitlements);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entitlements(Entitlement ... entitlements) {
            this.entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entitlements(Consumer<Entitlement.Builder> ... entitlements) {
            this.entitlements(Stream.of(entitlements).map(c -> (Entitlement)((Entitlement.Builder)Entitlement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        @Transient
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final List<MediaStream.Builder> getMediaStreams() {
            List<MediaStream.Builder> result = ___listOfMediaStreamCopier.copyToBuilder(this.mediaStreams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaStreams(Collection<MediaStream.BuilderImpl> mediaStreams) {
            this.mediaStreams = ___listOfMediaStreamCopier.copyFromBuilder(mediaStreams);
        }

        @Override
        @Transient
        public final Builder mediaStreams(Collection<MediaStream> mediaStreams) {
            this.mediaStreams = ___listOfMediaStreamCopier.copy(mediaStreams);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mediaStreams(MediaStream ... mediaStreams) {
            this.mediaStreams(Arrays.asList(mediaStreams));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mediaStreams(Consumer<MediaStream.Builder> ... mediaStreams) {
            this.mediaStreams(Stream.of(mediaStreams).map(c -> (MediaStream)((MediaStream.Builder)MediaStream.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Output.Builder> getOutputs() {
            List<Output.Builder> result = ___listOfOutputCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = ___listOfOutputCopier.copyFromBuilder(outputs);
        }

        @Override
        @Transient
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = ___listOfOutputCopier.copy(outputs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (Output)((Output.Builder)Output.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        @Transient
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final FailoverConfig.Builder getSourceFailoverConfig() {
            return this.sourceFailoverConfig != null ? this.sourceFailoverConfig.toBuilder() : null;
        }

        public final void setSourceFailoverConfig(FailoverConfig.BuilderImpl sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig != null ? sourceFailoverConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceFailoverConfig(FailoverConfig sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        public final List<Source.Builder> getSources() {
            List<Source.Builder> result = ___listOfSourceCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<Source.BuilderImpl> sources) {
            this.sources = ___listOfSourceCopier.copyFromBuilder(sources);
        }

        @Override
        @Transient
        public final Builder sources(Collection<Source> sources) {
            this.sources = ___listOfSourceCopier.copy(sources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sources(Source ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sources(Consumer<Source.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (Source)((Source.Builder)Source.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<VpcInterface.Builder> getVpcInterfaces() {
            List<VpcInterface.Builder> result = ___listOfVpcInterfaceCopier.copyToBuilder(this.vpcInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcInterfaces(Collection<VpcInterface.BuilderImpl> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceCopier.copyFromBuilder(vpcInterfaces);
        }

        @Override
        @Transient
        public final Builder vpcInterfaces(Collection<VpcInterface> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceCopier.copy(vpcInterfaces);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcInterfaces(VpcInterface ... vpcInterfaces) {
            this.vpcInterfaces(Arrays.asList(vpcInterfaces));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcInterfaces(Consumer<VpcInterface.Builder> ... vpcInterfaces) {
            this.vpcInterfaces(Stream.of(vpcInterfaces).map(c -> (VpcInterface)((VpcInterface.Builder)VpcInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Flow build() {
            return new Flow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Flow> {
        public Builder availabilityZone(String var1);

        public Builder description(String var1);

        public Builder egressIp(String var1);

        public Builder entitlements(Collection<Entitlement> var1);

        public Builder entitlements(Entitlement ... var1);

        public Builder entitlements(Consumer<Entitlement.Builder> ... var1);

        public Builder flowArn(String var1);

        public Builder mediaStreams(Collection<MediaStream> var1);

        public Builder mediaStreams(MediaStream ... var1);

        public Builder mediaStreams(Consumer<MediaStream.Builder> ... var1);

        public Builder name(String var1);

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder outputs(Consumer<Output.Builder> ... var1);

        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder sourceFailoverConfig(FailoverConfig var1);

        default public Builder sourceFailoverConfig(Consumer<FailoverConfig.Builder> sourceFailoverConfig) {
            return this.sourceFailoverConfig((FailoverConfig)((FailoverConfig.Builder)FailoverConfig.builder().applyMutation(sourceFailoverConfig)).build());
        }

        public Builder sources(Collection<Source> var1);

        public Builder sources(Source ... var1);

        public Builder sources(Consumer<Source.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder vpcInterfaces(Collection<VpcInterface> var1);

        public Builder vpcInterfaces(VpcInterface ... var1);

        public Builder vpcInterfaces(Consumer<VpcInterface.Builder> ... var1);
    }
}

