/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.MediaStreamAttributesRequest;
import software.amazon.awssdk.services.mediaconnect.model.MediaStreamType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFlowMediaStreamRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, UpdateFlowMediaStreamRequest> {
    private static final SdkField<MediaStreamAttributesRequest> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attributes").getter(UpdateFlowMediaStreamRequest.getter(UpdateFlowMediaStreamRequest::attributes)).setter(UpdateFlowMediaStreamRequest.setter(Builder::attributes)).constructor(MediaStreamAttributesRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()}).build();
    private static final SdkField<Integer> CLOCK_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ClockRate").getter(UpdateFlowMediaStreamRequest.getter(UpdateFlowMediaStreamRequest::clockRate)).setter(UpdateFlowMediaStreamRequest.setter(Builder::clockRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clockRate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateFlowMediaStreamRequest.getter(UpdateFlowMediaStreamRequest::description)).setter(UpdateFlowMediaStreamRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(UpdateFlowMediaStreamRequest.getter(UpdateFlowMediaStreamRequest::flowArn)).setter(UpdateFlowMediaStreamRequest.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()}).build();
    private static final SdkField<String> MEDIA_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaStreamName").getter(UpdateFlowMediaStreamRequest.getter(UpdateFlowMediaStreamRequest::mediaStreamName)).setter(UpdateFlowMediaStreamRequest.setter(Builder::mediaStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("mediaStreamName").build()}).build();
    private static final SdkField<String> MEDIA_STREAM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaStreamType").getter(UpdateFlowMediaStreamRequest.getter(UpdateFlowMediaStreamRequest::mediaStreamTypeAsString)).setter(UpdateFlowMediaStreamRequest.setter(Builder::mediaStreamType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamType").build()}).build();
    private static final SdkField<String> VIDEO_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VideoFormat").getter(UpdateFlowMediaStreamRequest.getter(UpdateFlowMediaStreamRequest::videoFormat)).setter(UpdateFlowMediaStreamRequest.setter(Builder::videoFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, CLOCK_RATE_FIELD, DESCRIPTION_FIELD, FLOW_ARN_FIELD, MEDIA_STREAM_NAME_FIELD, MEDIA_STREAM_TYPE_FIELD, VIDEO_FORMAT_FIELD));
    private final MediaStreamAttributesRequest attributes;
    private final Integer clockRate;
    private final String description;
    private final String flowArn;
    private final String mediaStreamName;
    private final String mediaStreamType;
    private final String videoFormat;

    private UpdateFlowMediaStreamRequest(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
        this.clockRate = builder.clockRate;
        this.description = builder.description;
        this.flowArn = builder.flowArn;
        this.mediaStreamName = builder.mediaStreamName;
        this.mediaStreamType = builder.mediaStreamType;
        this.videoFormat = builder.videoFormat;
    }

    public final MediaStreamAttributesRequest attributes() {
        return this.attributes;
    }

    public final Integer clockRate() {
        return this.clockRate;
    }

    public final String description() {
        return this.description;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final String mediaStreamName() {
        return this.mediaStreamName;
    }

    public final MediaStreamType mediaStreamType() {
        return MediaStreamType.fromValue(this.mediaStreamType);
    }

    public final String mediaStreamTypeAsString() {
        return this.mediaStreamType;
    }

    public final String videoFormat() {
        return this.videoFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.clockRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaStreamTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoFormat());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowMediaStreamRequest)) {
            return false;
        }
        UpdateFlowMediaStreamRequest other = (UpdateFlowMediaStreamRequest)((Object)obj);
        return Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.clockRate(), other.clockRate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.mediaStreamName(), other.mediaStreamName()) && Objects.equals(this.mediaStreamTypeAsString(), other.mediaStreamTypeAsString()) && Objects.equals(this.videoFormat(), other.videoFormat());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFlowMediaStreamRequest").add("Attributes", (Object)this.attributes()).add("ClockRate", (Object)this.clockRate()).add("Description", (Object)this.description()).add("FlowArn", (Object)this.flowArn()).add("MediaStreamName", (Object)this.mediaStreamName()).add("MediaStreamType", (Object)this.mediaStreamTypeAsString()).add("VideoFormat", (Object)this.videoFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "ClockRate": {
                return Optional.ofNullable(clazz.cast(this.clockRate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "MediaStreamName": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamName()));
            }
            case "MediaStreamType": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamTypeAsString()));
            }
            case "VideoFormat": {
                return Optional.ofNullable(clazz.cast(this.videoFormat()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowMediaStreamRequest, T> g) {
        return obj -> g.apply((UpdateFlowMediaStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private MediaStreamAttributesRequest attributes;
        private Integer clockRate;
        private String description;
        private String flowArn;
        private String mediaStreamName;
        private String mediaStreamType;
        private String videoFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowMediaStreamRequest model) {
            super(model);
            this.attributes(model.attributes);
            this.clockRate(model.clockRate);
            this.description(model.description);
            this.flowArn(model.flowArn);
            this.mediaStreamName(model.mediaStreamName);
            this.mediaStreamType(model.mediaStreamType);
            this.videoFormat(model.videoFormat);
        }

        public final MediaStreamAttributesRequest.Builder getAttributes() {
            return this.attributes != null ? this.attributes.toBuilder() : null;
        }

        @Override
        public final Builder attributes(MediaStreamAttributesRequest attributes) {
            this.attributes = attributes;
            return this;
        }

        public final void setAttributes(MediaStreamAttributesRequest.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        public final Integer getClockRate() {
            return this.clockRate;
        }

        @Override
        public final Builder clockRate(Integer clockRate) {
            this.clockRate = clockRate;
            return this;
        }

        public final void setClockRate(Integer clockRate) {
            this.clockRate = clockRate;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final String getMediaStreamName() {
            return this.mediaStreamName;
        }

        @Override
        public final Builder mediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
            return this;
        }

        public final void setMediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
        }

        public final String getMediaStreamType() {
            return this.mediaStreamType;
        }

        @Override
        public final Builder mediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
            return this;
        }

        @Override
        public final Builder mediaStreamType(MediaStreamType mediaStreamType) {
            this.mediaStreamType(mediaStreamType == null ? null : mediaStreamType.toString());
            return this;
        }

        public final void setMediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
        }

        public final String getVideoFormat() {
            return this.videoFormat;
        }

        @Override
        public final Builder videoFormat(String videoFormat) {
            this.videoFormat = videoFormat;
            return this;
        }

        public final void setVideoFormat(String videoFormat) {
            this.videoFormat = videoFormat;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowMediaStreamRequest build() {
            return new UpdateFlowMediaStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFlowMediaStreamRequest> {
        public Builder attributes(MediaStreamAttributesRequest var1);

        default public Builder attributes(Consumer<MediaStreamAttributesRequest.Builder> attributes) {
            return this.attributes((MediaStreamAttributesRequest)((MediaStreamAttributesRequest.Builder)MediaStreamAttributesRequest.builder().applyMutation(attributes)).build());
        }

        public Builder clockRate(Integer var1);

        public Builder description(String var1);

        public Builder flowArn(String var1);

        public Builder mediaStreamName(String var1);

        public Builder mediaStreamType(String var1);

        public Builder mediaStreamType(MediaStreamType var1);

        public Builder videoFormat(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

