/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectAsyncClient;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListedFlow;

public class ListFlowsPublisher
implements SdkPublisher<ListFlowsResponse> {
    private final MediaConnectAsyncClient client;
    private final ListFlowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFlowsPublisher(MediaConnectAsyncClient client, ListFlowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFlowsPublisher(MediaConnectAsyncClient client, ListFlowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFlowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFlowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListedFlow> flows() {
        Function<ListFlowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flows() != null) {
                return response.flows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFlowsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFlowsResponseFetcher
    implements AsyncPageFetcher<ListFlowsResponse> {
        private ListFlowsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFlowsResponse> nextPage(ListFlowsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowsPublisher.this.client.listFlows(ListFlowsPublisher.this.firstRequest);
            }
            return ListFlowsPublisher.this.client.listFlows((ListFlowsRequest)((Object)ListFlowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

