/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Algorithm {
    AES128("aes128"),
    AES192("aes192"),
    AES256("aes256"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Algorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Algorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Algorithm.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Algorithm> knownValues() {
        return Stream.of(Algorithm.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

