/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.Encryption;
import software.amazon.awssdk.services.mediaconnect.model.EntitlementStatus;
import software.amazon.awssdk.services.mediaconnect.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GrantEntitlementRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GrantEntitlementRequest> {
    private static final SdkField<Integer> DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DataTransferSubscriberFeePercent").getter(GrantEntitlementRequest.getter(GrantEntitlementRequest::dataTransferSubscriberFeePercent)).setter(GrantEntitlementRequest.setter(Builder::dataTransferSubscriberFeePercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTransferSubscriberFeePercent").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GrantEntitlementRequest.getter(GrantEntitlementRequest::description)).setter(GrantEntitlementRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(GrantEntitlementRequest.getter(GrantEntitlementRequest::encryption)).setter(GrantEntitlementRequest.setter(Builder::encryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<String> ENTITLEMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntitlementStatus").getter(GrantEntitlementRequest.getter(GrantEntitlementRequest::entitlementStatusAsString)).setter(GrantEntitlementRequest.setter(Builder::entitlementStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementStatus").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GrantEntitlementRequest.getter(GrantEntitlementRequest::name)).setter(GrantEntitlementRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> SUBSCRIBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subscribers").getter(GrantEntitlementRequest.getter(GrantEntitlementRequest::subscribers)).setter(GrantEntitlementRequest.setter(Builder::subscribers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD, DESCRIPTION_FIELD, ENCRYPTION_FIELD, ENTITLEMENT_STATUS_FIELD, NAME_FIELD, SUBSCRIBERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer dataTransferSubscriberFeePercent;
    private final String description;
    private final Encryption encryption;
    private final String entitlementStatus;
    private final String name;
    private final List<String> subscribers;

    private GrantEntitlementRequest(BuilderImpl builder) {
        this.dataTransferSubscriberFeePercent = builder.dataTransferSubscriberFeePercent;
        this.description = builder.description;
        this.encryption = builder.encryption;
        this.entitlementStatus = builder.entitlementStatus;
        this.name = builder.name;
        this.subscribers = builder.subscribers;
    }

    public final Integer dataTransferSubscriberFeePercent() {
        return this.dataTransferSubscriberFeePercent;
    }

    public final String description() {
        return this.description;
    }

    public final Encryption encryption() {
        return this.encryption;
    }

    public final EntitlementStatus entitlementStatus() {
        return EntitlementStatus.fromValue(this.entitlementStatus);
    }

    public final String entitlementStatusAsString() {
        return this.entitlementStatus;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasSubscribers() {
        return this.subscribers != null && !(this.subscribers instanceof SdkAutoConstructList);
    }

    public final List<String> subscribers() {
        return this.subscribers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTransferSubscriberFeePercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscribers() ? this.subscribers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantEntitlementRequest)) {
            return false;
        }
        GrantEntitlementRequest other = (GrantEntitlementRequest)obj;
        return Objects.equals(this.dataTransferSubscriberFeePercent(), other.dataTransferSubscriberFeePercent()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.entitlementStatusAsString(), other.entitlementStatusAsString()) && Objects.equals(this.name(), other.name()) && this.hasSubscribers() == other.hasSubscribers() && Objects.equals(this.subscribers(), other.subscribers());
    }

    public final String toString() {
        return ToString.builder((String)"GrantEntitlementRequest").add("DataTransferSubscriberFeePercent", (Object)this.dataTransferSubscriberFeePercent()).add("Description", (Object)this.description()).add("Encryption", (Object)this.encryption()).add("EntitlementStatus", (Object)this.entitlementStatusAsString()).add("Name", (Object)this.name()).add("Subscribers", this.hasSubscribers() ? this.subscribers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataTransferSubscriberFeePercent": {
                return Optional.ofNullable(clazz.cast(this.dataTransferSubscriberFeePercent()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "EntitlementStatus": {
                return Optional.ofNullable(clazz.cast(this.entitlementStatusAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Subscribers": {
                return Optional.ofNullable(clazz.cast(this.subscribers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrantEntitlementRequest, T> g) {
        return obj -> g.apply((GrantEntitlementRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer dataTransferSubscriberFeePercent;
        private String description;
        private Encryption encryption;
        private String entitlementStatus;
        private String name;
        private List<String> subscribers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GrantEntitlementRequest model) {
            this.dataTransferSubscriberFeePercent(model.dataTransferSubscriberFeePercent);
            this.description(model.description);
            this.encryption(model.encryption);
            this.entitlementStatus(model.entitlementStatus);
            this.name(model.name);
            this.subscribers(model.subscribers);
        }

        public final Integer getDataTransferSubscriberFeePercent() {
            return this.dataTransferSubscriberFeePercent;
        }

        @Override
        public final Builder dataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
            return this;
        }

        public final void setDataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Encryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final String getEntitlementStatus() {
            return this.entitlementStatus;
        }

        @Override
        public final Builder entitlementStatus(String entitlementStatus) {
            this.entitlementStatus = entitlementStatus;
            return this;
        }

        @Override
        public final Builder entitlementStatus(EntitlementStatus entitlementStatus) {
            this.entitlementStatus(entitlementStatus == null ? null : entitlementStatus.toString());
            return this;
        }

        public final void setEntitlementStatus(String entitlementStatus) {
            this.entitlementStatus = entitlementStatus;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getSubscribers() {
            if (this.subscribers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subscribers;
        }

        @Override
        public final Builder subscribers(Collection<String> subscribers) {
            this.subscribers = ___listOf__stringCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(String ... subscribers) {
            this.subscribers(Arrays.asList(subscribers));
            return this;
        }

        public final void setSubscribers(Collection<String> subscribers) {
            this.subscribers = ___listOf__stringCopier.copy(subscribers);
        }

        public GrantEntitlementRequest build() {
            return new GrantEntitlementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GrantEntitlementRequest> {
        public Builder dataTransferSubscriberFeePercent(Integer var1);

        public Builder description(String var1);

        public Builder encryption(Encryption var1);

        default public Builder encryption(Consumer<Encryption.Builder> encryption) {
            return this.encryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(encryption)).build());
        }

        public Builder entitlementStatus(String var1);

        public Builder entitlementStatus(EntitlementStatus var1);

        public Builder name(String var1);

        public Builder subscribers(Collection<String> var1);

        public Builder subscribers(String ... var1);
    }
}

