/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.Protocol;
import software.amazon.awssdk.services.mediaconnect.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Transport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Transport> {
    private static final SdkField<List<String>> CIDR_ALLOW_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrAllowList").getter(Transport.getter(Transport::cidrAllowList)).setter(Transport.setter(Builder::cidrAllowList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrAllowList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxBitrate").getter(Transport.getter(Transport::maxBitrate)).setter(Transport.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxLatency").getter(Transport.getter(Transport::maxLatency)).setter(Transport.setter(Builder::maxLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(Transport.getter(Transport::protocolAsString)).setter(Transport.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> REMOTE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteId").getter(Transport.getter(Transport::remoteId)).setter(Transport.setter(Builder::remoteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteId").build()}).build();
    private static final SdkField<Integer> SMOOTHING_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SmoothingLatency").getter(Transport.getter(Transport::smoothingLatency)).setter(Transport.setter(Builder::smoothingLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smoothingLatency").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamId").getter(Transport.getter(Transport::streamId)).setter(Transport.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_ALLOW_LIST_FIELD, MAX_BITRATE_FIELD, MAX_LATENCY_FIELD, PROTOCOL_FIELD, REMOTE_ID_FIELD, SMOOTHING_LATENCY_FIELD, STREAM_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> cidrAllowList;
    private final Integer maxBitrate;
    private final Integer maxLatency;
    private final String protocol;
    private final String remoteId;
    private final Integer smoothingLatency;
    private final String streamId;

    private Transport(BuilderImpl builder) {
        this.cidrAllowList = builder.cidrAllowList;
        this.maxBitrate = builder.maxBitrate;
        this.maxLatency = builder.maxLatency;
        this.protocol = builder.protocol;
        this.remoteId = builder.remoteId;
        this.smoothingLatency = builder.smoothingLatency;
        this.streamId = builder.streamId;
    }

    public boolean hasCidrAllowList() {
        return this.cidrAllowList != null && !(this.cidrAllowList instanceof SdkAutoConstructList);
    }

    public List<String> cidrAllowList() {
        return this.cidrAllowList;
    }

    public Integer maxBitrate() {
        return this.maxBitrate;
    }

    public Integer maxLatency() {
        return this.maxLatency;
    }

    public Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public String remoteId() {
        return this.remoteId;
    }

    public Integer smoothingLatency() {
        return this.smoothingLatency;
    }

    public String streamId() {
        return this.streamId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrAllowList() ? this.cidrAllowList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.smoothingLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transport)) {
            return false;
        }
        Transport other = (Transport)obj;
        return this.hasCidrAllowList() == other.hasCidrAllowList() && Objects.equals(this.cidrAllowList(), other.cidrAllowList()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.maxLatency(), other.maxLatency()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.remoteId(), other.remoteId()) && Objects.equals(this.smoothingLatency(), other.smoothingLatency()) && Objects.equals(this.streamId(), other.streamId());
    }

    public String toString() {
        return ToString.builder((String)"Transport").add("CidrAllowList", this.hasCidrAllowList() ? this.cidrAllowList() : null).add("MaxBitrate", (Object)this.maxBitrate()).add("MaxLatency", (Object)this.maxLatency()).add("Protocol", (Object)this.protocolAsString()).add("RemoteId", (Object)this.remoteId()).add("SmoothingLatency", (Object)this.smoothingLatency()).add("StreamId", (Object)this.streamId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrAllowList": {
                return Optional.ofNullable(clazz.cast(this.cidrAllowList()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "MaxLatency": {
                return Optional.ofNullable(clazz.cast(this.maxLatency()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "RemoteId": {
                return Optional.ofNullable(clazz.cast(this.remoteId()));
            }
            case "SmoothingLatency": {
                return Optional.ofNullable(clazz.cast(this.smoothingLatency()));
            }
            case "StreamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Transport, T> g) {
        return obj -> g.apply((Transport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> cidrAllowList = DefaultSdkAutoConstructList.getInstance();
        private Integer maxBitrate;
        private Integer maxLatency;
        private String protocol;
        private String remoteId;
        private Integer smoothingLatency;
        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(Transport model) {
            this.cidrAllowList(model.cidrAllowList);
            this.maxBitrate(model.maxBitrate);
            this.maxLatency(model.maxLatency);
            this.protocol(model.protocol);
            this.remoteId(model.remoteId);
            this.smoothingLatency(model.smoothingLatency);
            this.streamId(model.streamId);
        }

        public final Collection<String> getCidrAllowList() {
            if (this.cidrAllowList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrAllowList;
        }

        @Override
        public final Builder cidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOf__stringCopier.copy(cidrAllowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrAllowList(String ... cidrAllowList) {
            this.cidrAllowList(Arrays.asList(cidrAllowList));
            return this;
        }

        public final void setCidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOf__stringCopier.copy(cidrAllowList);
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getMaxLatency() {
            return this.maxLatency;
        }

        @Override
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getRemoteId() {
            return this.remoteId;
        }

        @Override
        public final Builder remoteId(String remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public final void setRemoteId(String remoteId) {
            this.remoteId = remoteId;
        }

        public final Integer getSmoothingLatency() {
            return this.smoothingLatency;
        }

        @Override
        public final Builder smoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
            return this;
        }

        public final void setSmoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public Transport build() {
            return new Transport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Transport> {
        public Builder cidrAllowList(Collection<String> var1);

        public Builder cidrAllowList(String ... var1);

        public Builder maxBitrate(Integer var1);

        public Builder maxLatency(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder remoteId(String var1);

        public Builder smoothingLatency(Integer var1);

        public Builder streamId(String var1);
    }
}

