/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.Output;
import software.amazon.awssdk.services.mediaconnect.model.___listOfOutputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddFlowOutputsResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, AddFlowOutputsResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddFlowOutputsResponse.getter(AddFlowOutputsResponse::flowArn)).setter(AddFlowOutputsResponse.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AddFlowOutputsResponse.getter(AddFlowOutputsResponse::outputs)).setter(AddFlowOutputsResponse.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Output::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, OUTPUTS_FIELD));
    private final String flowArn;
    private final List<Output> outputs;

    private AddFlowOutputsResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.outputs = builder.outputs;
    }

    public String flowArn() {
        return this.flowArn;
    }

    public boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public List<Output> outputs() {
        return this.outputs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddFlowOutputsResponse)) {
            return false;
        }
        AddFlowOutputsResponse other = (AddFlowOutputsResponse)((Object)obj);
        return Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.outputs(), other.outputs());
    }

    public String toString() {
        return ToString.builder((String)"AddFlowOutputsResponse").add("FlowArn", (Object)this.flowArn()).add("Outputs", this.outputs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddFlowOutputsResponse, T> g) {
        return obj -> g.apply((AddFlowOutputsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String flowArn;
        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddFlowOutputsResponse model) {
            super(model);
            this.flowArn(model.flowArn);
            this.outputs(model.outputs);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final Collection<Output.Builder> getOutputs() {
            return this.outputs != null ? (Collection)this.outputs.stream().map(Output::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = ___listOfOutputCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (Output)((Output.Builder)Output.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = ___listOfOutputCopier.copyFromBuilder(outputs);
        }

        @Override
        public AddFlowOutputsResponse build() {
            return new AddFlowOutputsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddFlowOutputsResponse> {
        public Builder flowArn(String var1);

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder outputs(Consumer<Output.Builder> ... var1);
    }
}

