/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for source failover
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailoverConfig implements SdkPojo, Serializable, ToCopyableBuilder<FailoverConfig.Builder, FailoverConfig> {
    private static final SdkField<Integer> RECOVERY_WINDOW_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(FailoverConfig::recoveryWindow)).setter(setter(Builder::recoveryWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryWindow").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FailoverConfig::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_WINDOW_FIELD,
            STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer recoveryWindow;

    private final String state;

    private FailoverConfig(BuilderImpl builder) {
        this.recoveryWindow = builder.recoveryWindow;
        this.state = builder.state;
    }

    /**
     * Search window time to look for dash-7 packets
     * 
     * @return Search window time to look for dash-7 packets
     */
    public Integer recoveryWindow() {
        return recoveryWindow;
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see State
     */
    public State state() {
        return State.fromValue(state);
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see State
     */
    public String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recoveryWindow());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverConfig)) {
            return false;
        }
        FailoverConfig other = (FailoverConfig) obj;
        return Objects.equals(recoveryWindow(), other.recoveryWindow()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FailoverConfig").add("RecoveryWindow", recoveryWindow()).add("State", stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecoveryWindow":
            return Optional.ofNullable(clazz.cast(recoveryWindow()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailoverConfig, T> g) {
        return obj -> g.apply((FailoverConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailoverConfig> {
        /**
         * Search window time to look for dash-7 packets
         * 
         * @param recoveryWindow
         *        Search window time to look for dash-7 packets
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryWindow(Integer recoveryWindow);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);
    }

    static final class BuilderImpl implements Builder {
        private Integer recoveryWindow;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverConfig model) {
            recoveryWindow(model.recoveryWindow);
            state(model.state);
        }

        public final Integer getRecoveryWindow() {
            return recoveryWindow;
        }

        @Override
        public final Builder recoveryWindow(Integer recoveryWindow) {
            this.recoveryWindow = recoveryWindow;
            return this;
        }

        public final void setRecoveryWindow(Integer recoveryWindow) {
            this.recoveryWindow = recoveryWindow;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public FailoverConfig build() {
            return new FailoverConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
