/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlowOutputResponse extends MediaConnectResponse implements
        ToCopyableBuilder<UpdateFlowOutputResponse.Builder, UpdateFlowOutputResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFlowOutputResponse::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<Output> OUTPUT_FIELD = SdkField.<Output> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateFlowOutputResponse::output)).setter(setter(Builder::output)).constructor(Output::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, OUTPUT_FIELD));

    private final String flowArn;

    private final Output output;

    private UpdateFlowOutputResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.output = builder.output;
    }

    /**
     * The ARN of the flow that is associated with the updated output.
     * 
     * @return The ARN of the flow that is associated with the updated output.
     */
    public String flowArn() {
        return flowArn;
    }

    /**
     * Returns the value of the Output property for this object.
     * 
     * @return The value of the Output property for this object.
     */
    public Output output() {
        return output;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowOutputResponse)) {
            return false;
        }
        UpdateFlowOutputResponse other = (UpdateFlowOutputResponse) obj;
        return Objects.equals(flowArn(), other.flowArn()) && Objects.equals(output(), other.output());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateFlowOutputResponse").add("FlowArn", flowArn()).add("Output", output()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "Output":
            return Optional.ofNullable(clazz.cast(output()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowOutputResponse, T> g) {
        return obj -> g.apply((UpdateFlowOutputResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFlowOutputResponse> {
        /**
         * The ARN of the flow that is associated with the updated output.
         * 
         * @param flowArn
         *        The ARN of the flow that is associated with the updated output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * Sets the value of the Output property for this object.
         *
         * @param output
         *        The new value for the Output property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(Output output);

        /**
         * Sets the value of the Output property for this object.
         *
         * This is a convenience that creates an instance of the {@link Output.Builder} avoiding the need to create one
         * manually via {@link Output#builder()}.
         *
         * When the {@link Consumer} completes, {@link Output.Builder#build()} is called immediately and its result is
         * passed to {@link #output(Output)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link Output.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(Output)
         */
        default Builder output(Consumer<Output.Builder> output) {
            return output(Output.builder().applyMutation(output).build());
        }
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private String flowArn;

        private Output output;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowOutputResponse model) {
            super(model);
            flowArn(model.flowArn);
            output(model.output);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final Output.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        @Override
        public final Builder output(Output output) {
            this.output = output;
            return this;
        }

        public final void setOutput(Output.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public UpdateFlowOutputResponse build() {
            return new UpdateFlowOutputResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
