/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Attributes related to the transport stream that are used in a source or output.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Transport implements SdkPojo, Serializable, ToCopyableBuilder<Transport.Builder, Transport> {
    private static final SdkField<List<String>> CIDR_ALLOW_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Transport::cidrAllowList))
            .setter(setter(Builder::cidrAllowList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrAllowList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Transport::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Transport::maxLatency)).setter(setter(Builder::maxLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Transport::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> REMOTE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Transport::remoteId)).setter(setter(Builder::remoteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteId").build()).build();

    private static final SdkField<Integer> SMOOTHING_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Transport::smoothingLatency)).setter(setter(Builder::smoothingLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smoothingLatency").build()).build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Transport::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_ALLOW_LIST_FIELD,
            MAX_BITRATE_FIELD, MAX_LATENCY_FIELD, PROTOCOL_FIELD, REMOTE_ID_FIELD, SMOOTHING_LATENCY_FIELD, STREAM_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> cidrAllowList;

    private final Integer maxBitrate;

    private final Integer maxLatency;

    private final String protocol;

    private final String remoteId;

    private final Integer smoothingLatency;

    private final String streamId;

    private Transport(BuilderImpl builder) {
        this.cidrAllowList = builder.cidrAllowList;
        this.maxBitrate = builder.maxBitrate;
        this.maxLatency = builder.maxLatency;
        this.protocol = builder.protocol;
        this.remoteId = builder.remoteId;
        this.smoothingLatency = builder.smoothingLatency;
        this.streamId = builder.streamId;
    }

    /**
     * Returns true if the CidrAllowList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCidrAllowList() {
        return cidrAllowList != null && !(cidrAllowList instanceof SdkAutoConstructList);
    }

    /**
     * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses
     * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCidrAllowList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The range of IP addresses that should be allowed to initiate output requests to this flow. These IP
     *         addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
     *         10.0.0.0/16.
     */
    public List<String> cidrAllowList() {
        return cidrAllowList;
    }

    /**
     * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
     * 
     * @return The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
     */
    public Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
     * 
     * @return The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
     */
    public Integer maxLatency() {
        return maxLatency;
    }

    /**
     * The protocol that is used by the source or output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol that is used by the source or output.
     * @see Protocol
     */
    public Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * The protocol that is used by the source or output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol that is used by the source or output.
     * @see Protocol
     */
    public String protocolAsString() {
        return protocol;
    }

    /**
     * The remote ID for the Zixi-pull stream.
     * 
     * @return The remote ID for the Zixi-pull stream.
     */
    public String remoteId() {
        return remoteId;
    }

    /**
     * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     * 
     * @return The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     */
    public Integer smoothingLatency() {
        return smoothingLatency;
    }

    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     * 
     * @return The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     */
    public String streamId() {
        return streamId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidrAllowList());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(maxLatency());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(remoteId());
        hashCode = 31 * hashCode + Objects.hashCode(smoothingLatency());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transport)) {
            return false;
        }
        Transport other = (Transport) obj;
        return Objects.equals(cidrAllowList(), other.cidrAllowList()) && Objects.equals(maxBitrate(), other.maxBitrate())
                && Objects.equals(maxLatency(), other.maxLatency())
                && Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(remoteId(), other.remoteId())
                && Objects.equals(smoothingLatency(), other.smoothingLatency()) && Objects.equals(streamId(), other.streamId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Transport").add("CidrAllowList", cidrAllowList()).add("MaxBitrate", maxBitrate())
                .add("MaxLatency", maxLatency()).add("Protocol", protocolAsString()).add("RemoteId", remoteId())
                .add("SmoothingLatency", smoothingLatency()).add("StreamId", streamId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrAllowList":
            return Optional.ofNullable(clazz.cast(cidrAllowList()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "MaxLatency":
            return Optional.ofNullable(clazz.cast(maxLatency()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "RemoteId":
            return Optional.ofNullable(clazz.cast(remoteId()));
        case "SmoothingLatency":
            return Optional.ofNullable(clazz.cast(smoothingLatency()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Transport, T> g) {
        return obj -> g.apply((Transport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Transport> {
        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses
         * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * 
         * @param cidrAllowList
         *        The range of IP addresses that should be allowed to initiate output requests to this flow. These IP
         *        addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
         *        10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAllowList(Collection<String> cidrAllowList);

        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses
         * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * 
         * @param cidrAllowList
         *        The range of IP addresses that should be allowed to initiate output requests to this flow. These IP
         *        addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
         *        10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAllowList(String... cidrAllowList);

        /**
         * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
         * 
         * @param maxBitrate
         *        The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
         * 
         * @param maxLatency
         *        The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLatency(Integer maxLatency);

        /**
         * The protocol that is used by the source or output.
         * 
         * @param protocol
         *        The protocol that is used by the source or output.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * The protocol that is used by the source or output.
         * 
         * @param protocol
         *        The protocol that is used by the source or output.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * The remote ID for the Zixi-pull stream.
         * 
         * @param remoteId
         *        The remote ID for the Zixi-pull stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteId(String remoteId);

        /**
         * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         * 
         * @param smoothingLatency
         *        The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smoothingLatency(Integer smoothingLatency);

        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         * 
         * @param streamId
         *        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based
         *        streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);
    }

    static final class BuilderImpl implements Builder {
        private List<String> cidrAllowList = DefaultSdkAutoConstructList.getInstance();

        private Integer maxBitrate;

        private Integer maxLatency;

        private String protocol;

        private String remoteId;

        private Integer smoothingLatency;

        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(Transport model) {
            cidrAllowList(model.cidrAllowList);
            maxBitrate(model.maxBitrate);
            maxLatency(model.maxLatency);
            protocol(model.protocol);
            remoteId(model.remoteId);
            smoothingLatency(model.smoothingLatency);
            streamId(model.streamId);
        }

        public final Collection<String> getCidrAllowList() {
            return cidrAllowList;
        }

        @Override
        public final Builder cidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOf__stringCopier.copy(cidrAllowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrAllowList(String... cidrAllowList) {
            cidrAllowList(Arrays.asList(cidrAllowList));
            return this;
        }

        public final void setCidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOf__stringCopier.copy(cidrAllowList);
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getMaxLatency() {
            return maxLatency;
        }

        @Override
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        public final String getProtocolAsString() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getRemoteId() {
            return remoteId;
        }

        @Override
        public final Builder remoteId(String remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public final void setRemoteId(String remoteId) {
            this.remoteId = remoteId;
        }

        public final Integer getSmoothingLatency() {
            return smoothingLatency;
        }

        @Override
        public final Builder smoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
            return this;
        }

        public final void setSmoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
        }

        public final String getStreamId() {
            return streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public Transport build() {
            return new Transport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
