/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the blockchain address and network information about a contract.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContractIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<ContractIdentifier.Builder, ContractIdentifier> {
    private static final SdkField<String> NETWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("network")
            .getter(getter(ContractIdentifier::networkAsString)).setter(setter(Builder::network))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()).build();

    private static final SdkField<String> CONTRACT_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contractAddress").getter(getter(ContractIdentifier::contractAddress))
            .setter(setter(Builder::contractAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contractAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_FIELD,
            CONTRACT_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String network;

    private final String contractAddress;

    private ContractIdentifier(BuilderImpl builder) {
        this.network = builder.network;
        this.contractAddress = builder.contractAddress;
    }

    /**
     * <p>
     * The blockchain network of the contract.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network of the contract.
     * @see QueryNetwork
     */
    public final QueryNetwork network() {
        return QueryNetwork.fromValue(network);
    }

    /**
     * <p>
     * The blockchain network of the contract.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network of the contract.
     * @see QueryNetwork
     */
    public final String networkAsString() {
        return network;
    }

    /**
     * <p>
     * Container for the blockchain address about a contract.
     * </p>
     * 
     * @return Container for the blockchain address about a contract.
     */
    public final String contractAddress() {
        return contractAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contractAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContractIdentifier)) {
            return false;
        }
        ContractIdentifier other = (ContractIdentifier) obj;
        return Objects.equals(networkAsString(), other.networkAsString())
                && Objects.equals(contractAddress(), other.contractAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContractIdentifier").add("Network", networkAsString()).add("ContractAddress", contractAddress())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "network":
            return Optional.ofNullable(clazz.cast(networkAsString()));
        case "contractAddress":
            return Optional.ofNullable(clazz.cast(contractAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("network", NETWORK_FIELD);
        map.put("contractAddress", CONTRACT_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContractIdentifier, T> g) {
        return obj -> g.apply((ContractIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContractIdentifier> {
        /**
         * <p>
         * The blockchain network of the contract.
         * </p>
         * 
         * @param network
         *        The blockchain network of the contract.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(String network);

        /**
         * <p>
         * The blockchain network of the contract.
         * </p>
         * 
         * @param network
         *        The blockchain network of the contract.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(QueryNetwork network);

        /**
         * <p>
         * Container for the blockchain address about a contract.
         * </p>
         * 
         * @param contractAddress
         *        Container for the blockchain address about a contract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contractAddress(String contractAddress);
    }

    static final class BuilderImpl implements Builder {
        private String network;

        private String contractAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ContractIdentifier model) {
            network(model.network);
            contractAddress(model.contractAddress);
        }

        public final String getNetwork() {
            return network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        @Override
        public final Builder network(QueryNetwork network) {
            this.network(network == null ? null : network.toString());
            return this;
        }

        public final String getContractAddress() {
            return contractAddress;
        }

        public final void setContractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
        }

        @Override
        public final Builder contractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
            return this;
        }

        @Override
        public ContractIdentifier build() {
            return new ContractIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
