/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchainquery.ManagedBlockchainQueryClient;
import software.amazon.awssdk.services.managedblockchainquery.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.TransactionEvent;

public class ListTransactionEventsIterable
implements SdkIterable<ListTransactionEventsResponse> {
    private final ManagedBlockchainQueryClient client;
    private final ListTransactionEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTransactionEventsIterable(ManagedBlockchainQueryClient client, ListTransactionEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTransactionEventsResponseFetcher();
    }

    public Iterator<ListTransactionEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransactionEvent> events() {
        Function<ListTransactionEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTransactionEventsResponseFetcher
    implements SyncPageFetcher<ListTransactionEventsResponse> {
        private ListTransactionEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListTransactionEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTransactionEventsResponse nextPage(ListTransactionEventsResponse previousPage) {
            if (previousPage == null) {
                return ListTransactionEventsIterable.this.client.listTransactionEvents(ListTransactionEventsIterable.this.firstRequest);
            }
            return ListTransactionEventsIterable.this.client.listTransactionEvents((ListTransactionEventsRequest)((Object)ListTransactionEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

