/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchainquery.ManagedBlockchainQueryClient;
import software.amazon.awssdk.services.managedblockchainquery.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchainquery.model.AssetContract;
import software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsResponse;

public class ListAssetContractsIterable
implements SdkIterable<ListAssetContractsResponse> {
    private final ManagedBlockchainQueryClient client;
    private final ListAssetContractsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssetContractsIterable(ManagedBlockchainQueryClient client, ListAssetContractsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssetContractsResponseFetcher();
    }

    public Iterator<ListAssetContractsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssetContract> contracts() {
        Function<ListAssetContractsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contracts() != null) {
                return response.contracts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssetContractsResponseFetcher
    implements SyncPageFetcher<ListAssetContractsResponse> {
        private ListAssetContractsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetContractsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssetContractsResponse nextPage(ListAssetContractsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetContractsIterable.this.client.listAssetContracts(ListAssetContractsIterable.this.firstRequest);
            }
            return ListAssetContractsIterable.this.client.listAssetContracts((ListAssetContractsRequest)((Object)ListAssetContractsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

