/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Attributes of Hyperledger Fabric for a peer node on a Hyperledger Fabric network on Managed Blockchain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeFabricAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeFabricAttributes.Builder, NodeFabricAttributes> {
    private static final SdkField<String> PEER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeerEndpoint").getter(getter(NodeFabricAttributes::peerEndpoint)).setter(setter(Builder::peerEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerEndpoint").build()).build();

    private static final SdkField<String> PEER_EVENT_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeerEventEndpoint").getter(getter(NodeFabricAttributes::peerEventEndpoint))
            .setter(setter(Builder::peerEventEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerEventEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PEER_ENDPOINT_FIELD,
            PEER_EVENT_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String peerEndpoint;

    private final String peerEventEndpoint;

    private NodeFabricAttributes(BuilderImpl builder) {
        this.peerEndpoint = builder.peerEndpoint;
        this.peerEventEndpoint = builder.peerEventEndpoint;
    }

    /**
     * <p>
     * The endpoint that identifies the peer node for all services except peer channel-based event services.
     * </p>
     * 
     * @return The endpoint that identifies the peer node for all services except peer channel-based event services.
     */
    public final String peerEndpoint() {
        return peerEndpoint;
    }

    /**
     * <p>
     * The endpoint that identifies the peer node for peer channel-based event services.
     * </p>
     * 
     * @return The endpoint that identifies the peer node for peer channel-based event services.
     */
    public final String peerEventEndpoint() {
        return peerEventEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(peerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(peerEventEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeFabricAttributes)) {
            return false;
        }
        NodeFabricAttributes other = (NodeFabricAttributes) obj;
        return Objects.equals(peerEndpoint(), other.peerEndpoint())
                && Objects.equals(peerEventEndpoint(), other.peerEventEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeFabricAttributes").add("PeerEndpoint", peerEndpoint())
                .add("PeerEventEndpoint", peerEventEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PeerEndpoint":
            return Optional.ofNullable(clazz.cast(peerEndpoint()));
        case "PeerEventEndpoint":
            return Optional.ofNullable(clazz.cast(peerEventEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PeerEndpoint", PEER_ENDPOINT_FIELD);
        map.put("PeerEventEndpoint", PEER_EVENT_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeFabricAttributes, T> g) {
        return obj -> g.apply((NodeFabricAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeFabricAttributes> {
        /**
         * <p>
         * The endpoint that identifies the peer node for all services except peer channel-based event services.
         * </p>
         * 
         * @param peerEndpoint
         *        The endpoint that identifies the peer node for all services except peer channel-based event services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerEndpoint(String peerEndpoint);

        /**
         * <p>
         * The endpoint that identifies the peer node for peer channel-based event services.
         * </p>
         * 
         * @param peerEventEndpoint
         *        The endpoint that identifies the peer node for peer channel-based event services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerEventEndpoint(String peerEventEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private String peerEndpoint;

        private String peerEventEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeFabricAttributes model) {
            peerEndpoint(model.peerEndpoint);
            peerEventEndpoint(model.peerEventEndpoint);
        }

        public final String getPeerEndpoint() {
            return peerEndpoint;
        }

        public final void setPeerEndpoint(String peerEndpoint) {
            this.peerEndpoint = peerEndpoint;
        }

        @Override
        public final Builder peerEndpoint(String peerEndpoint) {
            this.peerEndpoint = peerEndpoint;
            return this;
        }

        public final String getPeerEventEndpoint() {
            return peerEventEndpoint;
        }

        public final void setPeerEventEndpoint(String peerEventEndpoint) {
            this.peerEventEndpoint = peerEventEndpoint;
        }

        @Override
        public final Builder peerEventEndpoint(String peerEventEndpoint) {
            this.peerEventEndpoint = peerEventEndpoint;
            return this;
        }

        @Override
        public NodeFabricAttributes build() {
            return new NodeFabricAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
