/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration properties for Hyperledger Fabric for a member in a Managed Blockchain network that is using the
 * Hyperledger Fabric framework.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberFabricConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MemberFabricConfiguration.Builder, MemberFabricConfiguration> {
    private static final SdkField<String> ADMIN_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdminUsername").getter(getter(MemberFabricConfiguration::adminUsername))
            .setter(setter(Builder::adminUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminUsername").build()).build();

    private static final SdkField<String> ADMIN_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdminPassword").getter(getter(MemberFabricConfiguration::adminPassword))
            .setter(setter(Builder::adminPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminPassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_USERNAME_FIELD,
            ADMIN_PASSWORD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String adminUsername;

    private final String adminPassword;

    private MemberFabricConfiguration(BuilderImpl builder) {
        this.adminUsername = builder.adminUsername;
        this.adminPassword = builder.adminPassword;
    }

    /**
     * <p>
     * The user name for the member's initial administrative user.
     * </p>
     * 
     * @return The user name for the member's initial administrative user.
     */
    public final String adminUsername() {
        return adminUsername;
    }

    /**
     * <p>
     * The password for the member's initial administrative user. The <code>AdminPassword</code> must be at least 8
     * characters long and no more than 32 characters. It must contain at least one uppercase letter, one lowercase
     * letter, and one digit. It cannot have a single quotation mark (‘), a double quotation marks (“), a forward
     * slash(/), a backward slash(\), @, or a space.
     * </p>
     * 
     * @return The password for the member's initial administrative user. The <code>AdminPassword</code> must be at
     *         least 8 characters long and no more than 32 characters. It must contain at least one uppercase letter,
     *         one lowercase letter, and one digit. It cannot have a single quotation mark (‘), a double quotation marks
     *         (“), a forward slash(/), a backward slash(\), @, or a space.
     */
    public final String adminPassword() {
        return adminPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adminUsername());
        hashCode = 31 * hashCode + Objects.hashCode(adminPassword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberFabricConfiguration)) {
            return false;
        }
        MemberFabricConfiguration other = (MemberFabricConfiguration) obj;
        return Objects.equals(adminUsername(), other.adminUsername()) && Objects.equals(adminPassword(), other.adminPassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemberFabricConfiguration").add("AdminUsername", adminUsername())
                .add("AdminPassword", adminPassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdminUsername":
            return Optional.ofNullable(clazz.cast(adminUsername()));
        case "AdminPassword":
            return Optional.ofNullable(clazz.cast(adminPassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdminUsername", ADMIN_USERNAME_FIELD);
        map.put("AdminPassword", ADMIN_PASSWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemberFabricConfiguration, T> g) {
        return obj -> g.apply((MemberFabricConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberFabricConfiguration> {
        /**
         * <p>
         * The user name for the member's initial administrative user.
         * </p>
         * 
         * @param adminUsername
         *        The user name for the member's initial administrative user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUsername(String adminUsername);

        /**
         * <p>
         * The password for the member's initial administrative user. The <code>AdminPassword</code> must be at least 8
         * characters long and no more than 32 characters. It must contain at least one uppercase letter, one lowercase
         * letter, and one digit. It cannot have a single quotation mark (‘), a double quotation marks (“), a forward
         * slash(/), a backward slash(\), @, or a space.
         * </p>
         * 
         * @param adminPassword
         *        The password for the member's initial administrative user. The <code>AdminPassword</code> must be at
         *        least 8 characters long and no more than 32 characters. It must contain at least one uppercase letter,
         *        one lowercase letter, and one digit. It cannot have a single quotation mark (‘), a double quotation
         *        marks (“), a forward slash(/), a backward slash(\), @, or a space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminPassword(String adminPassword);
    }

    static final class BuilderImpl implements Builder {
        private String adminUsername;

        private String adminPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberFabricConfiguration model) {
            adminUsername(model.adminUsername);
            adminPassword(model.adminPassword);
        }

        public final String getAdminUsername() {
            return adminUsername;
        }

        public final void setAdminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
        }

        @Override
        public final Builder adminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
            return this;
        }

        public final String getAdminPassword() {
            return adminPassword;
        }

        public final void setAdminPassword(String adminPassword) {
            this.adminPassword = adminPassword;
        }

        @Override
        public final Builder adminPassword(String adminPassword) {
            this.adminPassword = adminPassword;
            return this;
        }

        @Override
        public MemberFabricConfiguration build() {
            return new MemberFabricConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
