/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.ProposalStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProposalSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProposalSummary> {
    private static final SdkField<String> PROPOSAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProposalId").getter(ProposalSummary.getter(ProposalSummary::proposalId)).setter(ProposalSummary.setter(Builder::proposalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposalId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ProposalSummary.getter(ProposalSummary::description)).setter(ProposalSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PROPOSED_BY_MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProposedByMemberId").getter(ProposalSummary.getter(ProposalSummary::proposedByMemberId)).setter(ProposalSummary.setter(Builder::proposedByMemberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposedByMemberId").build()}).build();
    private static final SdkField<String> PROPOSED_BY_MEMBER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProposedByMemberName").getter(ProposalSummary.getter(ProposalSummary::proposedByMemberName)).setter(ProposalSummary.setter(Builder::proposedByMemberName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposedByMemberName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProposalSummary.getter(ProposalSummary::statusAsString)).setter(ProposalSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(ProposalSummary.getter(ProposalSummary::creationDate)).setter(ProposalSummary.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationDate").getter(ProposalSummary.getter(ProposalSummary::expirationDate)).setter(ProposalSummary.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPOSAL_ID_FIELD, DESCRIPTION_FIELD, PROPOSED_BY_MEMBER_ID_FIELD, PROPOSED_BY_MEMBER_NAME_FIELD, STATUS_FIELD, CREATION_DATE_FIELD, EXPIRATION_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String proposalId;
    private final String description;
    private final String proposedByMemberId;
    private final String proposedByMemberName;
    private final String status;
    private final Instant creationDate;
    private final Instant expirationDate;

    private ProposalSummary(BuilderImpl builder) {
        this.proposalId = builder.proposalId;
        this.description = builder.description;
        this.proposedByMemberId = builder.proposedByMemberId;
        this.proposedByMemberName = builder.proposedByMemberName;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
        this.expirationDate = builder.expirationDate;
    }

    public final String proposalId() {
        return this.proposalId;
    }

    public final String description() {
        return this.description;
    }

    public final String proposedByMemberId() {
        return this.proposedByMemberId;
    }

    public final String proposedByMemberName() {
        return this.proposedByMemberName;
    }

    public final ProposalStatus status() {
        return ProposalStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant expirationDate() {
        return this.expirationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.proposalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.proposedByMemberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.proposedByMemberName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProposalSummary)) {
            return false;
        }
        ProposalSummary other = (ProposalSummary)obj;
        return Objects.equals(this.proposalId(), other.proposalId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.proposedByMemberId(), other.proposedByMemberId()) && Objects.equals(this.proposedByMemberName(), other.proposedByMemberName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.expirationDate(), other.expirationDate());
    }

    public final String toString() {
        return ToString.builder((String)"ProposalSummary").add("ProposalId", (Object)this.proposalId()).add("Description", (Object)this.description()).add("ProposedByMemberId", (Object)this.proposedByMemberId()).add("ProposedByMemberName", (Object)this.proposedByMemberName()).add("Status", (Object)this.statusAsString()).add("CreationDate", (Object)this.creationDate()).add("ExpirationDate", (Object)this.expirationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProposalId": {
                return Optional.ofNullable(clazz.cast(this.proposalId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ProposedByMemberId": {
                return Optional.ofNullable(clazz.cast(this.proposedByMemberId()));
            }
            case "ProposedByMemberName": {
                return Optional.ofNullable(clazz.cast(this.proposedByMemberName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "ExpirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProposalSummary, T> g) {
        return obj -> g.apply((ProposalSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String proposalId;
        private String description;
        private String proposedByMemberId;
        private String proposedByMemberName;
        private String status;
        private Instant creationDate;
        private Instant expirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ProposalSummary model) {
            this.proposalId(model.proposalId);
            this.description(model.description);
            this.proposedByMemberId(model.proposedByMemberId);
            this.proposedByMemberName(model.proposedByMemberName);
            this.status(model.status);
            this.creationDate(model.creationDate);
            this.expirationDate(model.expirationDate);
        }

        public final String getProposalId() {
            return this.proposalId;
        }

        @Override
        public final Builder proposalId(String proposalId) {
            this.proposalId = proposalId;
            return this;
        }

        public final void setProposalId(String proposalId) {
            this.proposalId = proposalId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getProposedByMemberId() {
            return this.proposedByMemberId;
        }

        @Override
        public final Builder proposedByMemberId(String proposedByMemberId) {
            this.proposedByMemberId = proposedByMemberId;
            return this;
        }

        public final void setProposedByMemberId(String proposedByMemberId) {
            this.proposedByMemberId = proposedByMemberId;
        }

        public final String getProposedByMemberName() {
            return this.proposedByMemberName;
        }

        @Override
        public final Builder proposedByMemberName(String proposedByMemberName) {
            this.proposedByMemberName = proposedByMemberName;
            return this;
        }

        public final void setProposedByMemberName(String proposedByMemberName) {
            this.proposedByMemberName = proposedByMemberName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProposalStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        public ProposalSummary build() {
            return new ProposalSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProposalSummary> {
        public Builder proposalId(String var1);

        public Builder description(String var1);

        public Builder proposedByMemberId(String var1);

        public Builder proposedByMemberName(String var1);

        public Builder status(String var1);

        public Builder status(ProposalStatus var1);

        public Builder creationDate(Instant var1);

        public Builder expirationDate(Instant var1);
    }
}

