/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.managedblockchain.model.InviteAction;
import software.amazon.awssdk.services.managedblockchain.model.InviteActionListCopier;
import software.amazon.awssdk.services.managedblockchain.model.RemoveAction;
import software.amazon.awssdk.services.managedblockchain.model.RemoveActionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProposalActions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProposalActions> {
    private static final SdkField<List<InviteAction>> INVITATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Invitations").getter(ProposalActions.getter(ProposalActions::invitations)).setter(ProposalActions.setter(Builder::invitations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Invitations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InviteAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RemoveAction>> REMOVALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Removals").getter(ProposalActions.getter(ProposalActions::removals)).setter(ProposalActions.setter(Builder::removals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Removals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemoveAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITATIONS_FIELD, REMOVALS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<InviteAction> invitations;
    private final List<RemoveAction> removals;

    private ProposalActions(BuilderImpl builder) {
        this.invitations = builder.invitations;
        this.removals = builder.removals;
    }

    public boolean hasInvitations() {
        return this.invitations != null && !(this.invitations instanceof SdkAutoConstructList);
    }

    public List<InviteAction> invitations() {
        return this.invitations;
    }

    public boolean hasRemovals() {
        return this.removals != null && !(this.removals instanceof SdkAutoConstructList);
    }

    public List<RemoveAction> removals() {
        return this.removals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvitations() ? this.invitations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemovals() ? this.removals() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProposalActions)) {
            return false;
        }
        ProposalActions other = (ProposalActions)obj;
        return this.hasInvitations() == other.hasInvitations() && Objects.equals(this.invitations(), other.invitations()) && this.hasRemovals() == other.hasRemovals() && Objects.equals(this.removals(), other.removals());
    }

    public String toString() {
        return ToString.builder((String)"ProposalActions").add("Invitations", this.hasInvitations() ? this.invitations() : null).add("Removals", this.hasRemovals() ? this.removals() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Invitations": {
                return Optional.ofNullable(clazz.cast(this.invitations()));
            }
            case "Removals": {
                return Optional.ofNullable(clazz.cast(this.removals()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProposalActions, T> g) {
        return obj -> g.apply((ProposalActions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InviteAction> invitations = DefaultSdkAutoConstructList.getInstance();
        private List<RemoveAction> removals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProposalActions model) {
            this.invitations(model.invitations);
            this.removals(model.removals);
        }

        public final Collection<InviteAction.Builder> getInvitations() {
            if (this.invitations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.invitations != null ? (Collection)this.invitations.stream().map(InviteAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder invitations(Collection<InviteAction> invitations) {
            this.invitations = InviteActionListCopier.copy(invitations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invitations(InviteAction ... invitations) {
            this.invitations(Arrays.asList(invitations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invitations(Consumer<InviteAction.Builder> ... invitations) {
            this.invitations(Stream.of(invitations).map(c -> (InviteAction)((InviteAction.Builder)InviteAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInvitations(Collection<InviteAction.BuilderImpl> invitations) {
            this.invitations = InviteActionListCopier.copyFromBuilder(invitations);
        }

        public final Collection<RemoveAction.Builder> getRemovals() {
            if (this.removals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removals != null ? (Collection)this.removals.stream().map(RemoveAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder removals(Collection<RemoveAction> removals) {
            this.removals = RemoveActionListCopier.copy(removals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removals(RemoveAction ... removals) {
            this.removals(Arrays.asList(removals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removals(Consumer<RemoveAction.Builder> ... removals) {
            this.removals(Stream.of(removals).map(c -> (RemoveAction)((RemoveAction.Builder)RemoveAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRemovals(Collection<RemoveAction.BuilderImpl> removals) {
            this.removals = RemoveActionListCopier.copyFromBuilder(removals);
        }

        public ProposalActions build() {
            return new ProposalActions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProposalActions> {
        public Builder invitations(Collection<InviteAction> var1);

        public Builder invitations(InviteAction ... var1);

        public Builder invitations(Consumer<InviteAction.Builder> ... var1);

        public Builder removals(Collection<RemoveAction> var1);

        public Builder removals(RemoveAction ... var1);

        public Builder removals(Consumer<RemoveAction.Builder> ... var1);
    }
}

