/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.ThresholdComparator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApprovalThresholdPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApprovalThresholdPolicy> {
    private static final SdkField<Integer> THRESHOLD_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ApprovalThresholdPolicy.getter(ApprovalThresholdPolicy::thresholdPercentage)).setter(ApprovalThresholdPolicy.setter(Builder::thresholdPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdPercentage").build()}).build();
    private static final SdkField<Integer> PROPOSAL_DURATION_IN_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ApprovalThresholdPolicy.getter(ApprovalThresholdPolicy::proposalDurationInHours)).setter(ApprovalThresholdPolicy.setter(Builder::proposalDurationInHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposalDurationInHours").build()}).build();
    private static final SdkField<String> THRESHOLD_COMPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApprovalThresholdPolicy.getter(ApprovalThresholdPolicy::thresholdComparatorAsString)).setter(ApprovalThresholdPolicy.setter(Builder::thresholdComparator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdComparator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THRESHOLD_PERCENTAGE_FIELD, PROPOSAL_DURATION_IN_HOURS_FIELD, THRESHOLD_COMPARATOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer thresholdPercentage;
    private final Integer proposalDurationInHours;
    private final String thresholdComparator;

    private ApprovalThresholdPolicy(BuilderImpl builder) {
        this.thresholdPercentage = builder.thresholdPercentage;
        this.proposalDurationInHours = builder.proposalDurationInHours;
        this.thresholdComparator = builder.thresholdComparator;
    }

    public Integer thresholdPercentage() {
        return this.thresholdPercentage;
    }

    public Integer proposalDurationInHours() {
        return this.proposalDurationInHours;
    }

    public ThresholdComparator thresholdComparator() {
        return ThresholdComparator.fromValue(this.thresholdComparator);
    }

    public String thresholdComparatorAsString() {
        return this.thresholdComparator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.proposalDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdComparatorAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApprovalThresholdPolicy)) {
            return false;
        }
        ApprovalThresholdPolicy other = (ApprovalThresholdPolicy)obj;
        return Objects.equals(this.thresholdPercentage(), other.thresholdPercentage()) && Objects.equals(this.proposalDurationInHours(), other.proposalDurationInHours()) && Objects.equals(this.thresholdComparatorAsString(), other.thresholdComparatorAsString());
    }

    public String toString() {
        return ToString.builder((String)"ApprovalThresholdPolicy").add("ThresholdPercentage", (Object)this.thresholdPercentage()).add("ProposalDurationInHours", (Object)this.proposalDurationInHours()).add("ThresholdComparator", (Object)this.thresholdComparatorAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ThresholdPercentage": {
                return Optional.ofNullable(clazz.cast(this.thresholdPercentage()));
            }
            case "ProposalDurationInHours": {
                return Optional.ofNullable(clazz.cast(this.proposalDurationInHours()));
            }
            case "ThresholdComparator": {
                return Optional.ofNullable(clazz.cast(this.thresholdComparatorAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApprovalThresholdPolicy, T> g) {
        return obj -> g.apply((ApprovalThresholdPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer thresholdPercentage;
        private Integer proposalDurationInHours;
        private String thresholdComparator;

        private BuilderImpl() {
        }

        private BuilderImpl(ApprovalThresholdPolicy model) {
            this.thresholdPercentage(model.thresholdPercentage);
            this.proposalDurationInHours(model.proposalDurationInHours);
            this.thresholdComparator(model.thresholdComparator);
        }

        public final Integer getThresholdPercentage() {
            return this.thresholdPercentage;
        }

        @Override
        public final Builder thresholdPercentage(Integer thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
            return this;
        }

        public final void setThresholdPercentage(Integer thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
        }

        public final Integer getProposalDurationInHours() {
            return this.proposalDurationInHours;
        }

        @Override
        public final Builder proposalDurationInHours(Integer proposalDurationInHours) {
            this.proposalDurationInHours = proposalDurationInHours;
            return this;
        }

        public final void setProposalDurationInHours(Integer proposalDurationInHours) {
            this.proposalDurationInHours = proposalDurationInHours;
        }

        public final String getThresholdComparatorAsString() {
            return this.thresholdComparator;
        }

        @Override
        public final Builder thresholdComparator(String thresholdComparator) {
            this.thresholdComparator = thresholdComparator;
            return this;
        }

        @Override
        public final Builder thresholdComparator(ThresholdComparator thresholdComparator) {
            this.thresholdComparator(thresholdComparator == null ? null : thresholdComparator.toString());
            return this;
        }

        public final void setThresholdComparator(String thresholdComparator) {
            this.thresholdComparator = thresholdComparator;
        }

        public ApprovalThresholdPolicy build() {
            return new ApprovalThresholdPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApprovalThresholdPolicy> {
        public Builder thresholdPercentage(Integer var1);

        public Builder proposalDurationInHours(Integer var1);

        public Builder thresholdComparator(String var1);

        public Builder thresholdComparator(ThresholdComparator var1);
    }
}

