/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.IngressBooleanOperator;
import software.amazon.awssdk.services.mailmanager.model.IngressBooleanToEvaluate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngressBooleanExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngressBooleanExpression> {
    private static final SdkField<IngressBooleanToEvaluate> EVALUATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Evaluate").getter(IngressBooleanExpression.getter(IngressBooleanExpression::evaluate)).setter(IngressBooleanExpression.setter(Builder::evaluate)).constructor(IngressBooleanToEvaluate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluate").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(IngressBooleanExpression.getter(IngressBooleanExpression::operatorAsString)).setter(IngressBooleanExpression.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATE_FIELD, OPERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IngressBooleanExpression.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final IngressBooleanToEvaluate evaluate;
    private final String operator;

    private IngressBooleanExpression(BuilderImpl builder) {
        this.evaluate = builder.evaluate;
        this.operator = builder.operator;
    }

    public final IngressBooleanToEvaluate evaluate() {
        return this.evaluate;
    }

    public final IngressBooleanOperator operator() {
        return IngressBooleanOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluate());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressBooleanExpression)) {
            return false;
        }
        IngressBooleanExpression other = (IngressBooleanExpression)obj;
        return Objects.equals(this.evaluate(), other.evaluate()) && Objects.equals(this.operatorAsString(), other.operatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IngressBooleanExpression").add("Evaluate", (Object)this.evaluate()).add("Operator", (Object)this.operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Evaluate": {
                return Optional.ofNullable(clazz.cast(this.evaluate()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Evaluate", EVALUATE_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressBooleanExpression, T> g) {
        return obj -> g.apply((IngressBooleanExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private IngressBooleanToEvaluate evaluate;
        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(IngressBooleanExpression model) {
            this.evaluate(model.evaluate);
            this.operator(model.operator);
        }

        public final IngressBooleanToEvaluate.Builder getEvaluate() {
            return this.evaluate != null ? this.evaluate.toBuilder() : null;
        }

        public final void setEvaluate(IngressBooleanToEvaluate.BuilderImpl evaluate) {
            this.evaluate = evaluate != null ? evaluate.build() : null;
        }

        @Override
        public final Builder evaluate(IngressBooleanToEvaluate evaluate) {
            this.evaluate = evaluate;
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(IngressBooleanOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public IngressBooleanExpression build() {
            return new IngressBooleanExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngressBooleanExpression> {
        public Builder evaluate(IngressBooleanToEvaluate var1);

        default public Builder evaluate(Consumer<IngressBooleanToEvaluate.Builder> evaluate) {
            return this.evaluate((IngressBooleanToEvaluate)((IngressBooleanToEvaluate.Builder)IngressBooleanToEvaluate.builder().applyMutation(evaluate)).build());
        }

        public Builder operator(String var1);

        public Builder operator(IngressBooleanOperator var1);
    }
}

