/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.ImportDataFormat;
import software.amazon.awssdk.services.mailmanager.model.ImportJobStatus;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAddressListImportJobResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, GetAddressListImportJobResponse> {
    private static final SdkField<String> ADDRESS_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressListId").getter(GetAddressListImportJobResponse.getter(GetAddressListImportJobResponse::addressListId)).setter(GetAddressListImportJobResponse.setter(Builder::addressListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressListId").build()}).build();
    private static final SdkField<Instant> COMPLETED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedTimestamp").getter(GetAddressListImportJobResponse.getter(GetAddressListImportJobResponse::completedTimestamp)).setter(GetAddressListImportJobResponse.setter(Builder::completedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedTimestamp").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(GetAddressListImportJobResponse.getter(GetAddressListImportJobResponse::createdTimestamp)).setter(GetAddressListImportJobResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Error").getter(GetAddressListImportJobResponse.getter(GetAddressListImportJobResponse::error)).setter(GetAddressListImportJobResponse.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<Integer> FAILED_ITEMS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailedItemsCount").getter(GetAddressListImportJobResponse.getter(GetAddressListImportJobResponse::failedItemsCount)).setter(GetAddressListImportJobResponse.setter(Builder::failedItemsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedItemsCount").build()}).build();
    private static final SdkField<ImportDataFormat> IMPORT_DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportDataFormat").getter(GetAddressListImportJobResponse.getter(GetAddressListImportJobResponse::importDataFormat)).setter(GetAddressListImportJobResponse.setter(Builder::importDataFormat)).constructor(ImportDataFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDataFormat").build()}).build();
    private static final SdkField<Integer> IMPORTED_ITEMS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ImportedItemsCount").getter(GetAddressListImportJobResponse.getter(GetAddressListImportJobResponse::importedItemsCount)).setter(GetAddressListImportJobResponse.setter(Builder::importedItemsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedItemsCount").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(GetAddressListImportJobResponse.getter(GetAddressListImportJobResponse::jobId)).setter(GetAddressListImportJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetAddressListImportJobResponse.getter(GetAddressListImportJobResponse::name)).setter(GetAddressListImportJobResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PRE_SIGNED_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreSignedUrl").getter(GetAddressListImportJobResponse.getter(GetAddressListImportJobResponse::preSignedUrl)).setter(GetAddressListImportJobResponse.setter(Builder::preSignedUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSignedUrl").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimestamp").getter(GetAddressListImportJobResponse.getter(GetAddressListImportJobResponse::startTimestamp)).setter(GetAddressListImportJobResponse.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetAddressListImportJobResponse.getter(GetAddressListImportJobResponse::statusAsString)).setter(GetAddressListImportJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_LIST_ID_FIELD, COMPLETED_TIMESTAMP_FIELD, CREATED_TIMESTAMP_FIELD, ERROR_FIELD, FAILED_ITEMS_COUNT_FIELD, IMPORT_DATA_FORMAT_FIELD, IMPORTED_ITEMS_COUNT_FIELD, JOB_ID_FIELD, NAME_FIELD, PRE_SIGNED_URL_FIELD, START_TIMESTAMP_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAddressListImportJobResponse.memberNameToFieldInitializer();
    private final String addressListId;
    private final Instant completedTimestamp;
    private final Instant createdTimestamp;
    private final String error;
    private final Integer failedItemsCount;
    private final ImportDataFormat importDataFormat;
    private final Integer importedItemsCount;
    private final String jobId;
    private final String name;
    private final String preSignedUrl;
    private final Instant startTimestamp;
    private final String status;

    private GetAddressListImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.addressListId = builder.addressListId;
        this.completedTimestamp = builder.completedTimestamp;
        this.createdTimestamp = builder.createdTimestamp;
        this.error = builder.error;
        this.failedItemsCount = builder.failedItemsCount;
        this.importDataFormat = builder.importDataFormat;
        this.importedItemsCount = builder.importedItemsCount;
        this.jobId = builder.jobId;
        this.name = builder.name;
        this.preSignedUrl = builder.preSignedUrl;
        this.startTimestamp = builder.startTimestamp;
        this.status = builder.status;
    }

    public final String addressListId() {
        return this.addressListId;
    }

    public final Instant completedTimestamp() {
        return this.completedTimestamp;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final String error() {
        return this.error;
    }

    public final Integer failedItemsCount() {
        return this.failedItemsCount;
    }

    public final ImportDataFormat importDataFormat() {
        return this.importDataFormat;
    }

    public final Integer importedItemsCount() {
        return this.importedItemsCount;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String name() {
        return this.name;
    }

    public final String preSignedUrl() {
        return this.preSignedUrl;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    public final ImportJobStatus status() {
        return ImportJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.addressListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedItemsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.importDataFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedItemsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAddressListImportJobResponse)) {
            return false;
        }
        GetAddressListImportJobResponse other = (GetAddressListImportJobResponse)((Object)obj);
        return Objects.equals(this.addressListId(), other.addressListId()) && Objects.equals(this.completedTimestamp(), other.completedTimestamp()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.failedItemsCount(), other.failedItemsCount()) && Objects.equals(this.importDataFormat(), other.importDataFormat()) && Objects.equals(this.importedItemsCount(), other.importedItemsCount()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.preSignedUrl(), other.preSignedUrl()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetAddressListImportJobResponse").add("AddressListId", (Object)this.addressListId()).add("CompletedTimestamp", (Object)this.completedTimestamp()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("Error", (Object)this.error()).add("FailedItemsCount", (Object)this.failedItemsCount()).add("ImportDataFormat", (Object)this.importDataFormat()).add("ImportedItemsCount", (Object)this.importedItemsCount()).add("JobId", (Object)this.jobId()).add("Name", (Object)this.name()).add("PreSignedUrl", (Object)(this.preSignedUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("StartTimestamp", (Object)this.startTimestamp()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddressListId": {
                return Optional.ofNullable(clazz.cast(this.addressListId()));
            }
            case "CompletedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.completedTimestamp()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "FailedItemsCount": {
                return Optional.ofNullable(clazz.cast(this.failedItemsCount()));
            }
            case "ImportDataFormat": {
                return Optional.ofNullable(clazz.cast(this.importDataFormat()));
            }
            case "ImportedItemsCount": {
                return Optional.ofNullable(clazz.cast(this.importedItemsCount()));
            }
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PreSignedUrl": {
                return Optional.ofNullable(clazz.cast(this.preSignedUrl()));
            }
            case "StartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AddressListId", ADDRESS_LIST_ID_FIELD);
        map.put("CompletedTimestamp", COMPLETED_TIMESTAMP_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("FailedItemsCount", FAILED_ITEMS_COUNT_FIELD);
        map.put("ImportDataFormat", IMPORT_DATA_FORMAT_FIELD);
        map.put("ImportedItemsCount", IMPORTED_ITEMS_COUNT_FIELD);
        map.put("JobId", JOB_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("PreSignedUrl", PRE_SIGNED_URL_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAddressListImportJobResponse, T> g) {
        return obj -> g.apply((GetAddressListImportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private String addressListId;
        private Instant completedTimestamp;
        private Instant createdTimestamp;
        private String error;
        private Integer failedItemsCount;
        private ImportDataFormat importDataFormat;
        private Integer importedItemsCount;
        private String jobId;
        private String name;
        private String preSignedUrl;
        private Instant startTimestamp;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAddressListImportJobResponse model) {
            super(model);
            this.addressListId(model.addressListId);
            this.completedTimestamp(model.completedTimestamp);
            this.createdTimestamp(model.createdTimestamp);
            this.error(model.error);
            this.failedItemsCount(model.failedItemsCount);
            this.importDataFormat(model.importDataFormat);
            this.importedItemsCount(model.importedItemsCount);
            this.jobId(model.jobId);
            this.name(model.name);
            this.preSignedUrl(model.preSignedUrl);
            this.startTimestamp(model.startTimestamp);
            this.status(model.status);
        }

        public final String getAddressListId() {
            return this.addressListId;
        }

        public final void setAddressListId(String addressListId) {
            this.addressListId = addressListId;
        }

        @Override
        public final Builder addressListId(String addressListId) {
            this.addressListId = addressListId;
            return this;
        }

        public final Instant getCompletedTimestamp() {
            return this.completedTimestamp;
        }

        public final void setCompletedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
        }

        @Override
        public final Builder completedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final Integer getFailedItemsCount() {
            return this.failedItemsCount;
        }

        public final void setFailedItemsCount(Integer failedItemsCount) {
            this.failedItemsCount = failedItemsCount;
        }

        @Override
        public final Builder failedItemsCount(Integer failedItemsCount) {
            this.failedItemsCount = failedItemsCount;
            return this;
        }

        public final ImportDataFormat.Builder getImportDataFormat() {
            return this.importDataFormat != null ? this.importDataFormat.toBuilder() : null;
        }

        public final void setImportDataFormat(ImportDataFormat.BuilderImpl importDataFormat) {
            this.importDataFormat = importDataFormat != null ? importDataFormat.build() : null;
        }

        @Override
        public final Builder importDataFormat(ImportDataFormat importDataFormat) {
            this.importDataFormat = importDataFormat;
            return this;
        }

        public final Integer getImportedItemsCount() {
            return this.importedItemsCount;
        }

        public final void setImportedItemsCount(Integer importedItemsCount) {
            this.importedItemsCount = importedItemsCount;
        }

        @Override
        public final Builder importedItemsCount(Integer importedItemsCount) {
            this.importedItemsCount = importedItemsCount;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPreSignedUrl() {
            return this.preSignedUrl;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetAddressListImportJobResponse build() {
            return new GetAddressListImportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAddressListImportJobResponse> {
        public Builder addressListId(String var1);

        public Builder completedTimestamp(Instant var1);

        public Builder createdTimestamp(Instant var1);

        public Builder error(String var1);

        public Builder failedItemsCount(Integer var1);

        public Builder importDataFormat(ImportDataFormat var1);

        default public Builder importDataFormat(Consumer<ImportDataFormat.Builder> importDataFormat) {
            return this.importDataFormat((ImportDataFormat)((ImportDataFormat.Builder)ImportDataFormat.builder().applyMutation(importDataFormat)).build());
        }

        public Builder importedItemsCount(Integer var1);

        public Builder jobId(String var1);

        public Builder name(String var1);

        public Builder preSignedUrl(String var1);

        public Builder startTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(ImportJobStatus var1);
    }
}

