/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mailmanager.model.Analysis;
import software.amazon.awssdk.services.mailmanager.model.RuleBooleanEmailAttribute;
import software.amazon.awssdk.services.mailmanager.model.RuleIsInAddressList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleBooleanToEvaluate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleBooleanToEvaluate> {
    private static final SdkField<Analysis> ANALYSIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Analysis").getter(RuleBooleanToEvaluate.getter(RuleBooleanToEvaluate::analysis)).setter(RuleBooleanToEvaluate.setter(Builder::analysis)).constructor(Analysis::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analysis").build()}).build();
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Attribute").getter(RuleBooleanToEvaluate.getter(RuleBooleanToEvaluate::attributeAsString)).setter(RuleBooleanToEvaluate.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()}).build();
    private static final SdkField<RuleIsInAddressList> IS_IN_ADDRESS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IsInAddressList").getter(RuleBooleanToEvaluate.getter(RuleBooleanToEvaluate::isInAddressList)).setter(RuleBooleanToEvaluate.setter(Builder::isInAddressList)).constructor(RuleIsInAddressList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsInAddressList").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_FIELD, ATTRIBUTE_FIELD, IS_IN_ADDRESS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleBooleanToEvaluate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Analysis analysis;
    private final String attribute;
    private final RuleIsInAddressList isInAddressList;
    private final Type type;

    private RuleBooleanToEvaluate(BuilderImpl builder) {
        this.analysis = builder.analysis;
        this.attribute = builder.attribute;
        this.isInAddressList = builder.isInAddressList;
        this.type = builder.type;
    }

    public final Analysis analysis() {
        return this.analysis;
    }

    public final RuleBooleanEmailAttribute attribute() {
        return RuleBooleanEmailAttribute.fromValue(this.attribute);
    }

    public final String attributeAsString() {
        return this.attribute;
    }

    public final RuleIsInAddressList isInAddressList() {
        return this.isInAddressList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.analysis());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isInAddressList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleBooleanToEvaluate)) {
            return false;
        }
        RuleBooleanToEvaluate other = (RuleBooleanToEvaluate)obj;
        return Objects.equals(this.analysis(), other.analysis()) && Objects.equals(this.attributeAsString(), other.attributeAsString()) && Objects.equals(this.isInAddressList(), other.isInAddressList());
    }

    public final String toString() {
        return ToString.builder((String)"RuleBooleanToEvaluate").add("Analysis", (Object)this.analysis()).add("Attribute", (Object)this.attributeAsString()).add("IsInAddressList", (Object)this.isInAddressList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Analysis": {
                return Optional.ofNullable(clazz.cast(this.analysis()));
            }
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
            case "IsInAddressList": {
                return Optional.ofNullable(clazz.cast(this.isInAddressList()));
            }
        }
        return Optional.empty();
    }

    public static RuleBooleanToEvaluate fromAnalysis(Analysis analysis) {
        return (RuleBooleanToEvaluate)RuleBooleanToEvaluate.builder().analysis(analysis).build();
    }

    public static RuleBooleanToEvaluate fromAnalysis(Consumer<Analysis.Builder> analysis) {
        Analysis.Builder builder = Analysis.builder();
        analysis.accept(builder);
        return RuleBooleanToEvaluate.fromAnalysis((Analysis)builder.build());
    }

    public static RuleBooleanToEvaluate fromAttribute(String attribute) {
        return (RuleBooleanToEvaluate)RuleBooleanToEvaluate.builder().attribute(attribute).build();
    }

    public static RuleBooleanToEvaluate fromAttribute(RuleBooleanEmailAttribute attribute) {
        return (RuleBooleanToEvaluate)RuleBooleanToEvaluate.builder().attribute(attribute).build();
    }

    public static RuleBooleanToEvaluate fromIsInAddressList(RuleIsInAddressList isInAddressList) {
        return (RuleBooleanToEvaluate)RuleBooleanToEvaluate.builder().isInAddressList(isInAddressList).build();
    }

    public static RuleBooleanToEvaluate fromIsInAddressList(Consumer<RuleIsInAddressList.Builder> isInAddressList) {
        RuleIsInAddressList.Builder builder = RuleIsInAddressList.builder();
        isInAddressList.accept(builder);
        return RuleBooleanToEvaluate.fromIsInAddressList((RuleIsInAddressList)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Analysis", ANALYSIS_FIELD);
        map.put("Attribute", ATTRIBUTE_FIELD);
        map.put("IsInAddressList", IS_IN_ADDRESS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleBooleanToEvaluate, T> g) {
        return obj -> g.apply((RuleBooleanToEvaluate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ANALYSIS,
        ATTRIBUTE,
        IS_IN_ADDRESS_LIST,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Analysis analysis;
        private String attribute;
        private RuleIsInAddressList isInAddressList;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RuleBooleanToEvaluate model) {
            this.analysis(model.analysis);
            this.attribute(model.attribute);
            this.isInAddressList(model.isInAddressList);
        }

        public final Analysis.Builder getAnalysis() {
            return this.analysis != null ? this.analysis.toBuilder() : null;
        }

        public final void setAnalysis(Analysis.BuilderImpl analysis) {
            Analysis oldValue = this.analysis;
            this.analysis = analysis != null ? analysis.build() : null;
            this.handleUnionValueChange(Type.ANALYSIS, oldValue, this.analysis);
        }

        @Override
        public final Builder analysis(Analysis analysis) {
            Analysis oldValue = this.analysis;
            this.analysis = analysis;
            this.handleUnionValueChange(Type.ANALYSIS, oldValue, this.analysis);
            return this;
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            String oldValue = this.attribute;
            this.attribute = attribute;
            this.handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
        }

        @Override
        public final Builder attribute(String attribute) {
            String oldValue = this.attribute;
            this.attribute = attribute;
            this.handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
            return this;
        }

        @Override
        public final Builder attribute(RuleBooleanEmailAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final RuleIsInAddressList.Builder getIsInAddressList() {
            return this.isInAddressList != null ? this.isInAddressList.toBuilder() : null;
        }

        public final void setIsInAddressList(RuleIsInAddressList.BuilderImpl isInAddressList) {
            RuleIsInAddressList oldValue = this.isInAddressList;
            this.isInAddressList = isInAddressList != null ? isInAddressList.build() : null;
            this.handleUnionValueChange(Type.IS_IN_ADDRESS_LIST, oldValue, this.isInAddressList);
        }

        @Override
        public final Builder isInAddressList(RuleIsInAddressList isInAddressList) {
            RuleIsInAddressList oldValue = this.isInAddressList;
            this.isInAddressList = isInAddressList;
            this.handleUnionValueChange(Type.IS_IN_ADDRESS_LIST, oldValue, this.isInAddressList);
            return this;
        }

        public RuleBooleanToEvaluate build() {
            return new RuleBooleanToEvaluate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleBooleanToEvaluate> {
        public Builder analysis(Analysis var1);

        default public Builder analysis(Consumer<Analysis.Builder> analysis) {
            return this.analysis((Analysis)((Analysis.Builder)Analysis.builder().applyMutation(analysis)).build());
        }

        public Builder attribute(String var1);

        public Builder attribute(RuleBooleanEmailAttribute var1);

        public Builder isInAddressList(RuleIsInAddressList var1);

        default public Builder isInAddressList(Consumer<RuleIsInAddressList.Builder> isInAddressList) {
            return this.isInAddressList((RuleIsInAddressList)((RuleIsInAddressList.Builder)RuleIsInAddressList.builder().applyMutation(isInAddressList)).build());
        }
    }
}

