/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.Archive;
import software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListArchivesResponse;

public class ListArchivesIterable
implements SdkIterable<ListArchivesResponse> {
    private final MailManagerClient client;
    private final ListArchivesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListArchivesIterable(MailManagerClient client, ListArchivesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListArchivesResponseFetcher();
    }

    public Iterator<ListArchivesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Archive> archives() {
        Function<ListArchivesResponse, Iterator> getIterator = response -> {
            if (response != null && response.archives() != null) {
                return response.archives().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListArchivesResponseFetcher
    implements SyncPageFetcher<ListArchivesResponse> {
        private ListArchivesResponseFetcher() {
        }

        public boolean hasNextPage(ListArchivesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListArchivesResponse nextPage(ListArchivesResponse previousPage) {
            if (previousPage == null) {
                return ListArchivesIterable.this.client.listArchives(ListArchivesIterable.this.firstRequest);
            }
            return ListArchivesIterable.this.client.listArchives((ListArchivesRequest)((Object)ListArchivesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

