/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.AddressList;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListsResponse;

public class ListAddressListsIterable
implements SdkIterable<ListAddressListsResponse> {
    private final MailManagerClient client;
    private final ListAddressListsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAddressListsIterable(MailManagerClient client, ListAddressListsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAddressListsResponseFetcher();
    }

    public Iterator<ListAddressListsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AddressList> addressLists() {
        Function<ListAddressListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.addressLists() != null) {
                return response.addressLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAddressListsResponseFetcher
    implements SyncPageFetcher<ListAddressListsResponse> {
        private ListAddressListsResponseFetcher() {
        }

        public boolean hasNextPage(ListAddressListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAddressListsResponse nextPage(ListAddressListsResponse previousPage) {
            if (previousPage == null) {
                return ListAddressListsIterable.this.client.listAddressLists(ListAddressListsIterable.this.firstRequest);
            }
            return ListAddressListsIterable.this.client.listAddressLists((ListAddressListsRequest)((Object)ListAddressListsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

