/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.ImportDataFormat;
import software.amazon.awssdk.services.mailmanager.model.MailManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAddressListImportJobRequest
extends MailManagerRequest
implements ToCopyableBuilder<Builder, CreateAddressListImportJobRequest> {
    private static final SdkField<String> ADDRESS_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressListId").getter(CreateAddressListImportJobRequest.getter(CreateAddressListImportJobRequest::addressListId)).setter(CreateAddressListImportJobRequest.setter(Builder::addressListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressListId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateAddressListImportJobRequest.getter(CreateAddressListImportJobRequest::clientToken)).setter(CreateAddressListImportJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<ImportDataFormat> IMPORT_DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportDataFormat").getter(CreateAddressListImportJobRequest.getter(CreateAddressListImportJobRequest::importDataFormat)).setter(CreateAddressListImportJobRequest.setter(Builder::importDataFormat)).constructor(ImportDataFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDataFormat").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateAddressListImportJobRequest.getter(CreateAddressListImportJobRequest::name)).setter(CreateAddressListImportJobRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_LIST_ID_FIELD, CLIENT_TOKEN_FIELD, IMPORT_DATA_FORMAT_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAddressListImportJobRequest.memberNameToFieldInitializer();
    private final String addressListId;
    private final String clientToken;
    private final ImportDataFormat importDataFormat;
    private final String name;

    private CreateAddressListImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.addressListId = builder.addressListId;
        this.clientToken = builder.clientToken;
        this.importDataFormat = builder.importDataFormat;
        this.name = builder.name;
    }

    public final String addressListId() {
        return this.addressListId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ImportDataFormat importDataFormat() {
        return this.importDataFormat;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.addressListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.importDataFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAddressListImportJobRequest)) {
            return false;
        }
        CreateAddressListImportJobRequest other = (CreateAddressListImportJobRequest)((Object)obj);
        return Objects.equals(this.addressListId(), other.addressListId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.importDataFormat(), other.importDataFormat()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAddressListImportJobRequest").add("AddressListId", (Object)this.addressListId()).add("ClientToken", (Object)this.clientToken()).add("ImportDataFormat", (Object)this.importDataFormat()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddressListId": {
                return Optional.ofNullable(clazz.cast(this.addressListId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ImportDataFormat": {
                return Optional.ofNullable(clazz.cast(this.importDataFormat()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AddressListId", ADDRESS_LIST_ID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ImportDataFormat", IMPORT_DATA_FORMAT_FIELD);
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAddressListImportJobRequest, T> g) {
        return obj -> g.apply((CreateAddressListImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerRequest.BuilderImpl
    implements Builder {
        private String addressListId;
        private String clientToken;
        private ImportDataFormat importDataFormat;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAddressListImportJobRequest model) {
            super(model);
            this.addressListId(model.addressListId);
            this.clientToken(model.clientToken);
            this.importDataFormat(model.importDataFormat);
            this.name(model.name);
        }

        public final String getAddressListId() {
            return this.addressListId;
        }

        public final void setAddressListId(String addressListId) {
            this.addressListId = addressListId;
        }

        @Override
        public final Builder addressListId(String addressListId) {
            this.addressListId = addressListId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ImportDataFormat.Builder getImportDataFormat() {
            return this.importDataFormat != null ? this.importDataFormat.toBuilder() : null;
        }

        public final void setImportDataFormat(ImportDataFormat.BuilderImpl importDataFormat) {
            this.importDataFormat = importDataFormat != null ? importDataFormat.build() : null;
        }

        @Override
        public final Builder importDataFormat(ImportDataFormat importDataFormat) {
            this.importDataFormat = importDataFormat;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAddressListImportJobRequest build() {
            return new CreateAddressListImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MailManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAddressListImportJobRequest> {
        public Builder addressListId(String var1);

        public Builder clientToken(String var1);

        public Builder importDataFormat(ImportDataFormat var1);

        default public Builder importDataFormat(Consumer<ImportDataFormat.Builder> importDataFormat) {
            return this.importDataFormat((ImportDataFormat)((ImportDataFormat.Builder)ImportDataFormat.builder().applyMutation(importDataFormat)).build());
        }

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

