/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.services.mailmanager.model.Row;
import software.amazon.awssdk.services.mailmanager.model.RowsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetArchiveSearchResultsResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, GetArchiveSearchResultsResponse> {
    private static final SdkField<List<Row>> ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rows").getter(GetArchiveSearchResultsResponse.getter(GetArchiveSearchResultsResponse::rows)).setter(GetArchiveSearchResultsResponse.setter(Builder::rows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Row::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROWS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetArchiveSearchResultsResponse.memberNameToFieldInitializer();
    private final List<Row> rows;

    private GetArchiveSearchResultsResponse(BuilderImpl builder) {
        super(builder);
        this.rows = builder.rows;
    }

    public final boolean hasRows() {
        return this.rows != null && !(this.rows instanceof SdkAutoConstructList);
    }

    public final List<Row> rows() {
        return this.rows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRows() ? this.rows() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchiveSearchResultsResponse)) {
            return false;
        }
        GetArchiveSearchResultsResponse other = (GetArchiveSearchResultsResponse)((Object)obj);
        return this.hasRows() == other.hasRows() && Objects.equals(this.rows(), other.rows());
    }

    public final String toString() {
        return ToString.builder((String)"GetArchiveSearchResultsResponse").add("Rows", this.hasRows() ? this.rows() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rows": {
                return Optional.ofNullable(clazz.cast(this.rows()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Row>>> map = new HashMap<String, SdkField<List<Row>>>();
        map.put("Rows", ROWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetArchiveSearchResultsResponse, T> g) {
        return obj -> g.apply((GetArchiveSearchResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private List<Row> rows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetArchiveSearchResultsResponse model) {
            super(model);
            this.rows(model.rows);
        }

        public final List<Row.Builder> getRows() {
            List<Row.Builder> result = RowsListCopier.copyToBuilder(this.rows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRows(Collection<Row.BuilderImpl> rows) {
            this.rows = RowsListCopier.copyFromBuilder(rows);
        }

        @Override
        public final Builder rows(Collection<Row> rows) {
            this.rows = RowsListCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Row ... rows) {
            this.rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<Row.Builder> ... rows) {
            this.rows(Stream.of(rows).map(c -> (Row)((Row.Builder)Row.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetArchiveSearchResultsResponse build() {
            return new GetArchiveSearchResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetArchiveSearchResultsResponse> {
        public Builder rows(Collection<Row> var1);

        public Builder rows(Row ... var1);

        public Builder rows(Consumer<Row.Builder> ... var1);
    }
}

