/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesResponse;
import software.amazon.awssdk.services.mailmanager.model.TrafficPolicy;

public class ListTrafficPoliciesIterable
implements SdkIterable<ListTrafficPoliciesResponse> {
    private final MailManagerClient client;
    private final ListTrafficPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrafficPoliciesIterable(MailManagerClient client, ListTrafficPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrafficPoliciesResponseFetcher();
    }

    public Iterator<ListTrafficPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrafficPolicy> trafficPolicies() {
        Function<ListTrafficPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.trafficPolicies() != null) {
                return response.trafficPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrafficPoliciesResponseFetcher
    implements SyncPageFetcher<ListTrafficPoliciesResponse> {
        private ListTrafficPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListTrafficPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrafficPoliciesResponse nextPage(ListTrafficPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListTrafficPoliciesIterable.this.client.listTrafficPolicies(ListTrafficPoliciesIterable.this.firstRequest);
            }
            return ListTrafficPoliciesIterable.this.client.listTrafficPolicies((ListTrafficPoliciesRequest)((Object)ListTrafficPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

