/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.ArchiveRetention;
import software.amazon.awssdk.services.mailmanager.model.ArchiveState;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetArchiveResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, GetArchiveResponse> {
    private static final SdkField<String> ARCHIVE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveArn").getter(GetArchiveResponse.getter(GetArchiveResponse::archiveArn)).setter(GetArchiveResponse.setter(Builder::archiveArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveArn").build()}).build();
    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveId").getter(GetArchiveResponse.getter(GetArchiveResponse::archiveId)).setter(GetArchiveResponse.setter(Builder::archiveId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveId").build()}).build();
    private static final SdkField<String> ARCHIVE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveName").getter(GetArchiveResponse.getter(GetArchiveResponse::archiveName)).setter(GetArchiveResponse.setter(Builder::archiveName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveName").build()}).build();
    private static final SdkField<String> ARCHIVE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveState").getter(GetArchiveResponse.getter(GetArchiveResponse::archiveStateAsString)).setter(GetArchiveResponse.setter(Builder::archiveState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveState").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(GetArchiveResponse.getter(GetArchiveResponse::createdTimestamp)).setter(GetArchiveResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(GetArchiveResponse.getter(GetArchiveResponse::kmsKeyArn)).setter(GetArchiveResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(GetArchiveResponse.getter(GetArchiveResponse::lastUpdatedTimestamp)).setter(GetArchiveResponse.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final SdkField<ArchiveRetention> RETENTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Retention").getter(GetArchiveResponse.getter(GetArchiveResponse::retention)).setter(GetArchiveResponse.setter(Builder::retention)).constructor(ArchiveRetention::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Retention").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_ARN_FIELD, ARCHIVE_ID_FIELD, ARCHIVE_NAME_FIELD, ARCHIVE_STATE_FIELD, CREATED_TIMESTAMP_FIELD, KMS_KEY_ARN_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, RETENTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ArchiveArn", ARCHIVE_ARN_FIELD);
            this.put("ArchiveId", ARCHIVE_ID_FIELD);
            this.put("ArchiveName", ARCHIVE_NAME_FIELD);
            this.put("ArchiveState", ARCHIVE_STATE_FIELD);
            this.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
            this.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
            this.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
            this.put("Retention", RETENTION_FIELD);
        }
    });
    private final String archiveArn;
    private final String archiveId;
    private final String archiveName;
    private final String archiveState;
    private final Instant createdTimestamp;
    private final String kmsKeyArn;
    private final Instant lastUpdatedTimestamp;
    private final ArchiveRetention retention;

    private GetArchiveResponse(BuilderImpl builder) {
        super(builder);
        this.archiveArn = builder.archiveArn;
        this.archiveId = builder.archiveId;
        this.archiveName = builder.archiveName;
        this.archiveState = builder.archiveState;
        this.createdTimestamp = builder.createdTimestamp;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.retention = builder.retention;
    }

    public final String archiveArn() {
        return this.archiveArn;
    }

    public final String archiveId() {
        return this.archiveId;
    }

    public final String archiveName() {
        return this.archiveName;
    }

    public final ArchiveState archiveState() {
        return ArchiveState.fromValue(this.archiveState);
    }

    public final String archiveStateAsString() {
        return this.archiveState;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public final ArchiveRetention retention() {
        return this.retention;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveName());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.retention());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchiveResponse)) {
            return false;
        }
        GetArchiveResponse other = (GetArchiveResponse)((Object)obj);
        return Objects.equals(this.archiveArn(), other.archiveArn()) && Objects.equals(this.archiveId(), other.archiveId()) && Objects.equals(this.archiveName(), other.archiveName()) && Objects.equals(this.archiveStateAsString(), other.archiveStateAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.retention(), other.retention());
    }

    public final String toString() {
        return ToString.builder((String)"GetArchiveResponse").add("ArchiveArn", (Object)this.archiveArn()).add("ArchiveId", (Object)this.archiveId()).add("ArchiveName", (Object)this.archiveName()).add("ArchiveState", (Object)this.archiveStateAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("Retention", (Object)this.retention()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveArn": {
                return Optional.ofNullable(clazz.cast(this.archiveArn()));
            }
            case "ArchiveId": {
                return Optional.ofNullable(clazz.cast(this.archiveId()));
            }
            case "ArchiveName": {
                return Optional.ofNullable(clazz.cast(this.archiveName()));
            }
            case "ArchiveState": {
                return Optional.ofNullable(clazz.cast(this.archiveStateAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "Retention": {
                return Optional.ofNullable(clazz.cast(this.retention()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetArchiveResponse, T> g) {
        return obj -> g.apply((GetArchiveResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private String archiveArn;
        private String archiveId;
        private String archiveName;
        private String archiveState;
        private Instant createdTimestamp;
        private String kmsKeyArn;
        private Instant lastUpdatedTimestamp;
        private ArchiveRetention retention;

        private BuilderImpl() {
        }

        private BuilderImpl(GetArchiveResponse model) {
            super(model);
            this.archiveArn(model.archiveArn);
            this.archiveId(model.archiveId);
            this.archiveName(model.archiveName);
            this.archiveState(model.archiveState);
            this.createdTimestamp(model.createdTimestamp);
            this.kmsKeyArn(model.kmsKeyArn);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.retention(model.retention);
        }

        public final String getArchiveArn() {
            return this.archiveArn;
        }

        public final void setArchiveArn(String archiveArn) {
            this.archiveArn = archiveArn;
        }

        @Override
        public final Builder archiveArn(String archiveArn) {
            this.archiveArn = archiveArn;
            return this;
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final String getArchiveName() {
            return this.archiveName;
        }

        public final void setArchiveName(String archiveName) {
            this.archiveName = archiveName;
        }

        @Override
        public final Builder archiveName(String archiveName) {
            this.archiveName = archiveName;
            return this;
        }

        public final String getArchiveState() {
            return this.archiveState;
        }

        public final void setArchiveState(String archiveState) {
            this.archiveState = archiveState;
        }

        @Override
        public final Builder archiveState(String archiveState) {
            this.archiveState = archiveState;
            return this;
        }

        @Override
        public final Builder archiveState(ArchiveState archiveState) {
            this.archiveState(archiveState == null ? null : archiveState.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final ArchiveRetention.Builder getRetention() {
            return this.retention != null ? this.retention.toBuilder() : null;
        }

        public final void setRetention(ArchiveRetention.BuilderImpl retention) {
            this.retention = retention != null ? retention.build() : null;
        }

        @Override
        public final Builder retention(ArchiveRetention retention) {
            this.retention = retention;
            return this;
        }

        @Override
        public GetArchiveResponse build() {
            return new GetArchiveResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetArchiveResponse> {
        public Builder archiveArn(String var1);

        public Builder archiveId(String var1);

        public Builder archiveName(String var1);

        public Builder archiveState(String var1);

        public Builder archiveState(ArchiveState var1);

        public Builder createdTimestamp(Instant var1);

        public Builder kmsKeyArn(String var1);

        public Builder lastUpdatedTimestamp(Instant var1);

        public Builder retention(ArchiveRetention var1);

        default public Builder retention(Consumer<ArchiveRetention.Builder> retention) {
            return this.retention((ArchiveRetention)((ArchiveRetention.Builder)ArchiveRetention.builder().applyMutation(retention)).build());
        }
    }
}

