/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Metadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Metadata> {
    private static final SdkField<String> INGRESS_POINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngressPointId").getter(Metadata.getter(Metadata::ingressPointId)).setter(Metadata.setter(Builder::ingressPointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointId").build()}).build();
    private static final SdkField<String> RULE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleSetId").getter(Metadata.getter(Metadata::ruleSetId)).setter(Metadata.setter(Builder::ruleSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetId").build()}).build();
    private static final SdkField<String> SENDER_HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SenderHostname").getter(Metadata.getter(Metadata::senderHostname)).setter(Metadata.setter(Builder::senderHostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderHostname").build()}).build();
    private static final SdkField<String> SENDER_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SenderIpAddress").getter(Metadata.getter(Metadata::senderIpAddress)).setter(Metadata.setter(Builder::senderIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderIpAddress").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(Metadata.getter(Metadata::timestamp)).setter(Metadata.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<String> TLS_CIPHER_SUITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TlsCipherSuite").getter(Metadata.getter(Metadata::tlsCipherSuite)).setter(Metadata.setter(Builder::tlsCipherSuite)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsCipherSuite").build()}).build();
    private static final SdkField<String> TLS_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TlsProtocol").getter(Metadata.getter(Metadata::tlsProtocol)).setter(Metadata.setter(Builder::tlsProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsProtocol").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyId").getter(Metadata.getter(Metadata::trafficPolicyId)).setter(Metadata.setter(Builder::trafficPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGRESS_POINT_ID_FIELD, RULE_SET_ID_FIELD, SENDER_HOSTNAME_FIELD, SENDER_IP_ADDRESS_FIELD, TIMESTAMP_FIELD, TLS_CIPHER_SUITE_FIELD, TLS_PROTOCOL_FIELD, TRAFFIC_POLICY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IngressPointId", INGRESS_POINT_ID_FIELD);
            this.put("RuleSetId", RULE_SET_ID_FIELD);
            this.put("SenderHostname", SENDER_HOSTNAME_FIELD);
            this.put("SenderIpAddress", SENDER_IP_ADDRESS_FIELD);
            this.put("Timestamp", TIMESTAMP_FIELD);
            this.put("TlsCipherSuite", TLS_CIPHER_SUITE_FIELD);
            this.put("TlsProtocol", TLS_PROTOCOL_FIELD);
            this.put("TrafficPolicyId", TRAFFIC_POLICY_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String ingressPointId;
    private final String ruleSetId;
    private final String senderHostname;
    private final String senderIpAddress;
    private final Instant timestamp;
    private final String tlsCipherSuite;
    private final String tlsProtocol;
    private final String trafficPolicyId;

    private Metadata(BuilderImpl builder) {
        this.ingressPointId = builder.ingressPointId;
        this.ruleSetId = builder.ruleSetId;
        this.senderHostname = builder.senderHostname;
        this.senderIpAddress = builder.senderIpAddress;
        this.timestamp = builder.timestamp;
        this.tlsCipherSuite = builder.tlsCipherSuite;
        this.tlsProtocol = builder.tlsProtocol;
        this.trafficPolicyId = builder.trafficPolicyId;
    }

    public final String ingressPointId() {
        return this.ingressPointId;
    }

    public final String ruleSetId() {
        return this.ruleSetId;
    }

    public final String senderHostname() {
        return this.senderHostname;
    }

    public final String senderIpAddress() {
        return this.senderIpAddress;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final String tlsCipherSuite() {
        return this.tlsCipherSuite;
    }

    public final String tlsProtocol() {
        return this.tlsProtocol;
    }

    public final String trafficPolicyId() {
        return this.trafficPolicyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressPointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderHostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsCipherSuite());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metadata)) {
            return false;
        }
        Metadata other = (Metadata)obj;
        return Objects.equals(this.ingressPointId(), other.ingressPointId()) && Objects.equals(this.ruleSetId(), other.ruleSetId()) && Objects.equals(this.senderHostname(), other.senderHostname()) && Objects.equals(this.senderIpAddress(), other.senderIpAddress()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.tlsCipherSuite(), other.tlsCipherSuite()) && Objects.equals(this.tlsProtocol(), other.tlsProtocol()) && Objects.equals(this.trafficPolicyId(), other.trafficPolicyId());
    }

    public final String toString() {
        return ToString.builder((String)"Metadata").add("IngressPointId", (Object)this.ingressPointId()).add("RuleSetId", (Object)this.ruleSetId()).add("SenderHostname", (Object)this.senderHostname()).add("SenderIpAddress", (Object)(this.senderIpAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("Timestamp", (Object)this.timestamp()).add("TlsCipherSuite", (Object)this.tlsCipherSuite()).add("TlsProtocol", (Object)this.tlsProtocol()).add("TrafficPolicyId", (Object)this.trafficPolicyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IngressPointId": {
                return Optional.ofNullable(clazz.cast(this.ingressPointId()));
            }
            case "RuleSetId": {
                return Optional.ofNullable(clazz.cast(this.ruleSetId()));
            }
            case "SenderHostname": {
                return Optional.ofNullable(clazz.cast(this.senderHostname()));
            }
            case "SenderIpAddress": {
                return Optional.ofNullable(clazz.cast(this.senderIpAddress()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "TlsCipherSuite": {
                return Optional.ofNullable(clazz.cast(this.tlsCipherSuite()));
            }
            case "TlsProtocol": {
                return Optional.ofNullable(clazz.cast(this.tlsProtocol()));
            }
            case "TrafficPolicyId": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Metadata, T> g) {
        return obj -> g.apply((Metadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ingressPointId;
        private String ruleSetId;
        private String senderHostname;
        private String senderIpAddress;
        private Instant timestamp;
        private String tlsCipherSuite;
        private String tlsProtocol;
        private String trafficPolicyId;

        private BuilderImpl() {
        }

        private BuilderImpl(Metadata model) {
            this.ingressPointId(model.ingressPointId);
            this.ruleSetId(model.ruleSetId);
            this.senderHostname(model.senderHostname);
            this.senderIpAddress(model.senderIpAddress);
            this.timestamp(model.timestamp);
            this.tlsCipherSuite(model.tlsCipherSuite);
            this.tlsProtocol(model.tlsProtocol);
            this.trafficPolicyId(model.trafficPolicyId);
        }

        public final String getIngressPointId() {
            return this.ingressPointId;
        }

        public final void setIngressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
        }

        @Override
        public final Builder ingressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
            return this;
        }

        public final String getRuleSetId() {
            return this.ruleSetId;
        }

        public final void setRuleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
        }

        @Override
        public final Builder ruleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        public final String getSenderHostname() {
            return this.senderHostname;
        }

        public final void setSenderHostname(String senderHostname) {
            this.senderHostname = senderHostname;
        }

        @Override
        public final Builder senderHostname(String senderHostname) {
            this.senderHostname = senderHostname;
            return this;
        }

        public final String getSenderIpAddress() {
            return this.senderIpAddress;
        }

        public final void setSenderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
        }

        @Override
        public final Builder senderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getTlsCipherSuite() {
            return this.tlsCipherSuite;
        }

        public final void setTlsCipherSuite(String tlsCipherSuite) {
            this.tlsCipherSuite = tlsCipherSuite;
        }

        @Override
        public final Builder tlsCipherSuite(String tlsCipherSuite) {
            this.tlsCipherSuite = tlsCipherSuite;
            return this;
        }

        public final String getTlsProtocol() {
            return this.tlsProtocol;
        }

        public final void setTlsProtocol(String tlsProtocol) {
            this.tlsProtocol = tlsProtocol;
        }

        @Override
        public final Builder tlsProtocol(String tlsProtocol) {
            this.tlsProtocol = tlsProtocol;
            return this;
        }

        public final String getTrafficPolicyId() {
            return this.trafficPolicyId;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public Metadata build() {
            return new Metadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Metadata> {
        public Builder ingressPointId(String var1);

        public Builder ruleSetId(String var1);

        public Builder senderHostname(String var1);

        public Builder senderIpAddress(String var1);

        public Builder timestamp(Instant var1);

        public Builder tlsCipherSuite(String var1);

        public Builder tlsProtocol(String var1);

        public Builder trafficPolicyId(String var1);
    }
}

