/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mailmanager.model.S3ExportDestinationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportDestinationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportDestinationConfiguration> {
    private static final SdkField<S3ExportDestinationConfiguration> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3").getter(ExportDestinationConfiguration.getter(ExportDestinationConfiguration::s3)).setter(ExportDestinationConfiguration.setter(Builder::s3)).constructor(S3ExportDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD));
    private static final long serialVersionUID = 1L;
    private final S3ExportDestinationConfiguration s3;
    private final Type type;

    private ExportDestinationConfiguration(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.type = builder.type;
    }

    public final S3ExportDestinationConfiguration s3() {
        return this.s3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportDestinationConfiguration)) {
            return false;
        }
        ExportDestinationConfiguration other = (ExportDestinationConfiguration)obj;
        return Objects.equals(this.s3(), other.s3());
    }

    public final String toString() {
        return ToString.builder((String)"ExportDestinationConfiguration").add("S3", (Object)this.s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
        }
        return Optional.empty();
    }

    public static ExportDestinationConfiguration fromS3(S3ExportDestinationConfiguration s3) {
        return (ExportDestinationConfiguration)ExportDestinationConfiguration.builder().s3(s3).build();
    }

    public static ExportDestinationConfiguration fromS3(Consumer<S3ExportDestinationConfiguration.Builder> s3) {
        S3ExportDestinationConfiguration.Builder builder = S3ExportDestinationConfiguration.builder();
        s3.accept(builder);
        return ExportDestinationConfiguration.fromS3((S3ExportDestinationConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportDestinationConfiguration, T> g) {
        return obj -> g.apply((ExportDestinationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S3,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private S3ExportDestinationConfiguration s3;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ExportDestinationConfiguration model) {
            this.s3(model.s3);
        }

        public final S3ExportDestinationConfiguration.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3ExportDestinationConfiguration.BuilderImpl s3) {
            S3ExportDestinationConfiguration oldValue = this.s3;
            this.s3 = s3 != null ? s3.build() : null;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3(S3ExportDestinationConfiguration s3) {
            S3ExportDestinationConfiguration oldValue = this.s3;
            this.s3 = s3;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        public ExportDestinationConfiguration build() {
            return new ExportDestinationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportDestinationConfiguration> {
        public Builder s3(S3ExportDestinationConfiguration var1);

        default public Builder s3(Consumer<S3ExportDestinationConfiguration.Builder> s3) {
            return this.s3((S3ExportDestinationConfiguration)((S3ExportDestinationConfiguration.Builder)S3ExportDestinationConfiguration.builder().applyMutation(s3)).build());
        }
    }
}

