/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Currency;
import software.amazon.awssdk.services.macie2.model.ServiceLimit;
import software.amazon.awssdk.services.macie2.model.UsageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageByAccount
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageByAccount> {
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currency").getter(UsageByAccount.getter(UsageByAccount::currencyAsString)).setter(UsageByAccount.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()}).build();
    private static final SdkField<String> ESTIMATED_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("estimatedCost").getter(UsageByAccount.getter(UsageByAccount::estimatedCost)).setter(UsageByAccount.setter(Builder::estimatedCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedCost").build()}).build();
    private static final SdkField<ServiceLimit> SERVICE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceLimit").getter(UsageByAccount.getter(UsageByAccount::serviceLimit)).setter(UsageByAccount.setter(Builder::serviceLimit)).constructor(ServiceLimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceLimit").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(UsageByAccount.getter(UsageByAccount::typeAsString)).setter(UsageByAccount.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_FIELD, ESTIMATED_COST_FIELD, SERVICE_LIMIT_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UsageByAccount.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String currency;
    private final String estimatedCost;
    private final ServiceLimit serviceLimit;
    private final String type;

    private UsageByAccount(BuilderImpl builder) {
        this.currency = builder.currency;
        this.estimatedCost = builder.estimatedCost;
        this.serviceLimit = builder.serviceLimit;
        this.type = builder.type;
    }

    public final Currency currency() {
        return Currency.fromValue(this.currency);
    }

    public final String currencyAsString() {
        return this.currency;
    }

    public final String estimatedCost() {
        return this.estimatedCost;
    }

    public final ServiceLimit serviceLimit() {
        return this.serviceLimit;
    }

    public final UsageType type() {
        return UsageType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageByAccount)) {
            return false;
        }
        UsageByAccount other = (UsageByAccount)obj;
        return Objects.equals(this.currencyAsString(), other.currencyAsString()) && Objects.equals(this.estimatedCost(), other.estimatedCost()) && Objects.equals(this.serviceLimit(), other.serviceLimit()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UsageByAccount").add("Currency", (Object)this.currencyAsString()).add("EstimatedCost", (Object)this.estimatedCost()).add("ServiceLimit", (Object)this.serviceLimit()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "currency": {
                return Optional.ofNullable(clazz.cast(this.currencyAsString()));
            }
            case "estimatedCost": {
                return Optional.ofNullable(clazz.cast(this.estimatedCost()));
            }
            case "serviceLimit": {
                return Optional.ofNullable(clazz.cast(this.serviceLimit()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("currency", CURRENCY_FIELD);
        map.put("estimatedCost", ESTIMATED_COST_FIELD);
        map.put("serviceLimit", SERVICE_LIMIT_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UsageByAccount, T> g) {
        return obj -> g.apply((UsageByAccount)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currency;
        private String estimatedCost;
        private ServiceLimit serviceLimit;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageByAccount model) {
            this.currency(model.currency);
            this.estimatedCost(model.estimatedCost);
            this.serviceLimit(model.serviceLimit);
            this.type(model.type);
        }

        public final String getCurrency() {
            return this.currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(Currency currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final String getEstimatedCost() {
            return this.estimatedCost;
        }

        public final void setEstimatedCost(String estimatedCost) {
            this.estimatedCost = estimatedCost;
        }

        @Override
        public final Builder estimatedCost(String estimatedCost) {
            this.estimatedCost = estimatedCost;
            return this;
        }

        public final ServiceLimit.Builder getServiceLimit() {
            return this.serviceLimit != null ? this.serviceLimit.toBuilder() : null;
        }

        public final void setServiceLimit(ServiceLimit.BuilderImpl serviceLimit) {
            this.serviceLimit = serviceLimit != null ? serviceLimit.build() : null;
        }

        @Override
        public final Builder serviceLimit(ServiceLimit serviceLimit) {
            this.serviceLimit = serviceLimit;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UsageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public UsageByAccount build() {
            return new UsageByAccount(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageByAccount> {
        public Builder currency(String var1);

        public Builder currency(Currency var1);

        public Builder estimatedCost(String var1);

        public Builder serviceLimit(ServiceLimit var1);

        default public Builder serviceLimit(Consumer<ServiceLimit.Builder> serviceLimit) {
            return this.serviceLimit((ServiceLimit)((ServiceLimit.Builder)ServiceLimit.builder().applyMutation(serviceLimit)).build());
        }

        public Builder type(String var1);

        public Builder type(UsageType var1);
    }
}

