/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.KeyValuePair;
import software.amazon.awssdk.services.macie2.model.KeyValuePairListCopier;
import software.amazon.awssdk.services.macie2.model.ServerSideEncryption;
import software.amazon.awssdk.services.macie2.model.StorageClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Object
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Object> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketArn").getter(S3Object.getter(S3Object::bucketArn)).setter(S3Object.setter(Builder::bucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketArn").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eTag").getter(S3Object.getter(S3Object::eTag)).setter(S3Object.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eTag").build()}).build();
    private static final SdkField<String> EXTENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("extension").getter(S3Object.getter(S3Object::extension)).setter(S3Object.setter(Builder::extension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extension").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(S3Object.getter(S3Object::key)).setter(S3Object.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModified").getter(S3Object.getter(S3Object::lastModified)).setter(S3Object.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(S3Object.getter(S3Object::path)).setter(S3Object.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<Boolean> PUBLIC_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publicAccess").getter(S3Object.getter(S3Object::publicAccess)).setter(S3Object.setter(Builder::publicAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAccess").build()}).build();
    private static final SdkField<ServerSideEncryption> SERVER_SIDE_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serverSideEncryption").getter(S3Object.getter(S3Object::serverSideEncryption)).setter(S3Object.setter(Builder::serverSideEncryption)).constructor(ServerSideEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverSideEncryption").build()}).build();
    private static final SdkField<Long> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("size").getter(S3Object.getter(S3Object::size)).setter(S3Object.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()}).build();
    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageClass").getter(S3Object.getter(S3Object::storageClassAsString)).setter(S3Object.setter(Builder::storageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageClass").build()}).build();
    private static final SdkField<List<KeyValuePair>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(S3Object.getter(S3Object::tags)).setter(S3Object.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionId").getter(S3Object.getter(S3Object::versionId)).setter(S3Object.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD, E_TAG_FIELD, EXTENSION_FIELD, KEY_FIELD, LAST_MODIFIED_FIELD, PATH_FIELD, PUBLIC_ACCESS_FIELD, SERVER_SIDE_ENCRYPTION_FIELD, SIZE_FIELD, STORAGE_CLASS_FIELD, TAGS_FIELD, VERSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3Object.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bucketArn;
    private final String eTag;
    private final String extension;
    private final String key;
    private final Instant lastModified;
    private final String path;
    private final Boolean publicAccess;
    private final ServerSideEncryption serverSideEncryption;
    private final Long size;
    private final String storageClass;
    private final List<KeyValuePair> tags;
    private final String versionId;

    private S3Object(BuilderImpl builder) {
        this.bucketArn = builder.bucketArn;
        this.eTag = builder.eTag;
        this.extension = builder.extension;
        this.key = builder.key;
        this.lastModified = builder.lastModified;
        this.path = builder.path;
        this.publicAccess = builder.publicAccess;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.size = builder.size;
        this.storageClass = builder.storageClass;
        this.tags = builder.tags;
        this.versionId = builder.versionId;
    }

    public final String bucketArn() {
        return this.bucketArn;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final String extension() {
        return this.extension;
    }

    public final String key() {
        return this.key;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final String path() {
        return this.path;
    }

    public final Boolean publicAccess() {
        return this.publicAccess;
    }

    public final ServerSideEncryption serverSideEncryption() {
        return this.serverSideEncryption;
    }

    public final Long size() {
        return this.size;
    }

    public final StorageClass storageClass() {
        return StorageClass.fromValue(this.storageClass);
    }

    public final String storageClassAsString() {
        return this.storageClass;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<KeyValuePair> tags() {
        return this.tags;
    }

    public final String versionId() {
        return this.versionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.extension());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Object)) {
            return false;
        }
        S3Object other = (S3Object)obj;
        return Objects.equals(this.bucketArn(), other.bucketArn()) && Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.extension(), other.extension()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.publicAccess(), other.publicAccess()) && Objects.equals(this.serverSideEncryption(), other.serverSideEncryption()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.storageClassAsString(), other.storageClassAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.versionId(), other.versionId());
    }

    public final String toString() {
        return ToString.builder((String)"S3Object").add("BucketArn", (Object)this.bucketArn()).add("ETag", (Object)this.eTag()).add("Extension", (Object)this.extension()).add("Key", (Object)this.key()).add("LastModified", (Object)this.lastModified()).add("Path", (Object)this.path()).add("PublicAccess", (Object)this.publicAccess()).add("ServerSideEncryption", (Object)this.serverSideEncryption()).add("Size", (Object)this.size()).add("StorageClass", (Object)this.storageClassAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("VersionId", (Object)this.versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketArn": {
                return Optional.ofNullable(clazz.cast(this.bucketArn()));
            }
            case "eTag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "extension": {
                return Optional.ofNullable(clazz.cast(this.extension()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "lastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "publicAccess": {
                return Optional.ofNullable(clazz.cast(this.publicAccess()));
            }
            case "serverSideEncryption": {
                return Optional.ofNullable(clazz.cast(this.serverSideEncryption()));
            }
            case "size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "storageClass": {
                return Optional.ofNullable(clazz.cast(this.storageClassAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "versionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bucketArn", BUCKET_ARN_FIELD);
        map.put("eTag", E_TAG_FIELD);
        map.put("extension", EXTENSION_FIELD);
        map.put("key", KEY_FIELD);
        map.put("lastModified", LAST_MODIFIED_FIELD);
        map.put("path", PATH_FIELD);
        map.put("publicAccess", PUBLIC_ACCESS_FIELD);
        map.put("serverSideEncryption", SERVER_SIDE_ENCRYPTION_FIELD);
        map.put("size", SIZE_FIELD);
        map.put("storageClass", STORAGE_CLASS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("versionId", VERSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Object, T> g) {
        return obj -> g.apply((S3Object)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketArn;
        private String eTag;
        private String extension;
        private String key;
        private Instant lastModified;
        private String path;
        private Boolean publicAccess;
        private ServerSideEncryption serverSideEncryption;
        private Long size;
        private String storageClass;
        private List<KeyValuePair> tags = DefaultSdkAutoConstructList.getInstance();
        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Object model) {
            this.bucketArn(model.bucketArn);
            this.eTag(model.eTag);
            this.extension(model.extension);
            this.key(model.key);
            this.lastModified(model.lastModified);
            this.path(model.path);
            this.publicAccess(model.publicAccess);
            this.serverSideEncryption(model.serverSideEncryption);
            this.size(model.size);
            this.storageClass(model.storageClass);
            this.tags(model.tags);
            this.versionId(model.versionId);
        }

        public final String getBucketArn() {
            return this.bucketArn;
        }

        public final void setBucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
        }

        @Override
        public final Builder bucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final String getExtension() {
            return this.extension;
        }

        public final void setExtension(String extension) {
            this.extension = extension;
        }

        @Override
        public final Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Boolean getPublicAccess() {
            return this.publicAccess;
        }

        public final void setPublicAccess(Boolean publicAccess) {
            this.publicAccess = publicAccess;
        }

        @Override
        public final Builder publicAccess(Boolean publicAccess) {
            this.publicAccess = publicAccess;
            return this;
        }

        public final ServerSideEncryption.Builder getServerSideEncryption() {
            return this.serverSideEncryption != null ? this.serverSideEncryption.toBuilder() : null;
        }

        public final void setServerSideEncryption(ServerSideEncryption.BuilderImpl serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption != null ? serverSideEncryption.build() : null;
        }

        @Override
        public final Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        public final Long getSize() {
            return this.size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass == null ? null : storageClass.toString());
            return this;
        }

        public final List<KeyValuePair.Builder> getTags() {
            List<KeyValuePair.Builder> result = KeyValuePairListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<KeyValuePair.BuilderImpl> tags) {
            this.tags = KeyValuePairListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<KeyValuePair> tags) {
            this.tags = KeyValuePairListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(KeyValuePair ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<KeyValuePair.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public S3Object build() {
            return new S3Object(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Object> {
        public Builder bucketArn(String var1);

        public Builder eTag(String var1);

        public Builder extension(String var1);

        public Builder key(String var1);

        public Builder lastModified(Instant var1);

        public Builder path(String var1);

        public Builder publicAccess(Boolean var1);

        public Builder serverSideEncryption(ServerSideEncryption var1);

        default public Builder serverSideEncryption(Consumer<ServerSideEncryption.Builder> serverSideEncryption) {
            return this.serverSideEncryption((ServerSideEncryption)((ServerSideEncryption.Builder)ServerSideEncryption.builder().applyMutation(serverSideEncryption)).build());
        }

        public Builder size(Long var1);

        public Builder storageClass(String var1);

        public Builder storageClass(StorageClass var1);

        public Builder tags(Collection<KeyValuePair> var1);

        public Builder tags(KeyValuePair ... var1);

        public Builder tags(Consumer<KeyValuePair.Builder> ... var1);

        public Builder versionId(String var1);
    }
}

