/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2Client;
import software.amazon.awssdk.services.macie2.internal.UserAgentUtils;
import software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccount;
import software.amazon.awssdk.services.macie2.model.ListAutomatedDiscoveryAccountsRequest;
import software.amazon.awssdk.services.macie2.model.ListAutomatedDiscoveryAccountsResponse;

public class ListAutomatedDiscoveryAccountsIterable
implements SdkIterable<ListAutomatedDiscoveryAccountsResponse> {
    private final Macie2Client client;
    private final ListAutomatedDiscoveryAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAutomatedDiscoveryAccountsIterable(Macie2Client client, ListAutomatedDiscoveryAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAutomatedDiscoveryAccountsResponseFetcher();
    }

    public Iterator<ListAutomatedDiscoveryAccountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AutomatedDiscoveryAccount> items() {
        Function<ListAutomatedDiscoveryAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAutomatedDiscoveryAccountsResponseFetcher
    implements SyncPageFetcher<ListAutomatedDiscoveryAccountsResponse> {
        private ListAutomatedDiscoveryAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomatedDiscoveryAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAutomatedDiscoveryAccountsResponse nextPage(ListAutomatedDiscoveryAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListAutomatedDiscoveryAccountsIterable.this.client.listAutomatedDiscoveryAccounts(ListAutomatedDiscoveryAccountsIterable.this.firstRequest);
            }
            return ListAutomatedDiscoveryAccountsIterable.this.client.listAutomatedDiscoveryAccounts((ListAutomatedDiscoveryAccountsRequest)((Object)ListAutomatedDiscoveryAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

