/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.services.macie2.model.SecurityHubConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutFindingsPublicationConfigurationRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, PutFindingsPublicationConfigurationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(PutFindingsPublicationConfigurationRequest.getter(PutFindingsPublicationConfigurationRequest::clientToken)).setter(PutFindingsPublicationConfigurationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<SecurityHubConfiguration> SECURITY_HUB_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("securityHubConfiguration").getter(PutFindingsPublicationConfigurationRequest.getter(PutFindingsPublicationConfigurationRequest::securityHubConfiguration)).setter(PutFindingsPublicationConfigurationRequest.setter(Builder::securityHubConfiguration)).constructor(SecurityHubConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityHubConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, SECURITY_HUB_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutFindingsPublicationConfigurationRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final SecurityHubConfiguration securityHubConfiguration;

    private PutFindingsPublicationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.securityHubConfiguration = builder.securityHubConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final SecurityHubConfiguration securityHubConfiguration() {
        return this.securityHubConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityHubConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFindingsPublicationConfigurationRequest)) {
            return false;
        }
        PutFindingsPublicationConfigurationRequest other = (PutFindingsPublicationConfigurationRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.securityHubConfiguration(), other.securityHubConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"PutFindingsPublicationConfigurationRequest").add("ClientToken", (Object)this.clientToken()).add("SecurityHubConfiguration", (Object)this.securityHubConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "securityHubConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityHubConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("securityHubConfiguration", SECURITY_HUB_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutFindingsPublicationConfigurationRequest, T> g) {
        return obj -> g.apply((PutFindingsPublicationConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private SecurityHubConfiguration securityHubConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFindingsPublicationConfigurationRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.securityHubConfiguration(model.securityHubConfiguration);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final SecurityHubConfiguration.Builder getSecurityHubConfiguration() {
            return this.securityHubConfiguration != null ? this.securityHubConfiguration.toBuilder() : null;
        }

        public final void setSecurityHubConfiguration(SecurityHubConfiguration.BuilderImpl securityHubConfiguration) {
            this.securityHubConfiguration = securityHubConfiguration != null ? securityHubConfiguration.build() : null;
        }

        @Override
        public final Builder securityHubConfiguration(SecurityHubConfiguration securityHubConfiguration) {
            this.securityHubConfiguration = securityHubConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutFindingsPublicationConfigurationRequest build() {
            return new PutFindingsPublicationConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutFindingsPublicationConfigurationRequest> {
        public Builder clientToken(String var1);

        public Builder securityHubConfiguration(SecurityHubConfiguration var1);

        default public Builder securityHubConfiguration(Consumer<SecurityHubConfiguration.Builder> securityHubConfiguration) {
            return this.securityHubConfiguration((SecurityHubConfiguration)((SecurityHubConfiguration.Builder)SecurityHubConfiguration.builder().applyMutation(securityHubConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

