/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.ClassificationScopeSummary;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.___listOfClassificationScopeSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClassificationScopesResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, ListClassificationScopesResponse> {
    private static final SdkField<List<ClassificationScopeSummary>> CLASSIFICATION_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("classificationScopes").getter(ListClassificationScopesResponse.getter(ListClassificationScopesResponse::classificationScopes)).setter(ListClassificationScopesResponse.setter(Builder::classificationScopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classificationScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClassificationScopeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListClassificationScopesResponse.getter(ListClassificationScopesResponse::nextToken)).setter(ListClassificationScopesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSIFICATION_SCOPES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("classificationScopes", CLASSIFICATION_SCOPES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ClassificationScopeSummary> classificationScopes;
    private final String nextToken;

    private ListClassificationScopesResponse(BuilderImpl builder) {
        super(builder);
        this.classificationScopes = builder.classificationScopes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasClassificationScopes() {
        return this.classificationScopes != null && !(this.classificationScopes instanceof SdkAutoConstructList);
    }

    public final List<ClassificationScopeSummary> classificationScopes() {
        return this.classificationScopes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClassificationScopes() ? this.classificationScopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClassificationScopesResponse)) {
            return false;
        }
        ListClassificationScopesResponse other = (ListClassificationScopesResponse)((Object)obj);
        return this.hasClassificationScopes() == other.hasClassificationScopes() && Objects.equals(this.classificationScopes(), other.classificationScopes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListClassificationScopesResponse").add("ClassificationScopes", this.hasClassificationScopes() ? this.classificationScopes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "classificationScopes": {
                return Optional.ofNullable(clazz.cast(this.classificationScopes()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListClassificationScopesResponse, T> g) {
        return obj -> g.apply((ListClassificationScopesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private List<ClassificationScopeSummary> classificationScopes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClassificationScopesResponse model) {
            super(model);
            this.classificationScopes(model.classificationScopes);
            this.nextToken(model.nextToken);
        }

        public final List<ClassificationScopeSummary.Builder> getClassificationScopes() {
            List<ClassificationScopeSummary.Builder> result = ___listOfClassificationScopeSummaryCopier.copyToBuilder(this.classificationScopes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClassificationScopes(Collection<ClassificationScopeSummary.BuilderImpl> classificationScopes) {
            this.classificationScopes = ___listOfClassificationScopeSummaryCopier.copyFromBuilder(classificationScopes);
        }

        @Override
        public final Builder classificationScopes(Collection<ClassificationScopeSummary> classificationScopes) {
            this.classificationScopes = ___listOfClassificationScopeSummaryCopier.copy(classificationScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classificationScopes(ClassificationScopeSummary ... classificationScopes) {
            this.classificationScopes(Arrays.asList(classificationScopes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classificationScopes(Consumer<ClassificationScopeSummary.Builder> ... classificationScopes) {
            this.classificationScopes(Stream.of(classificationScopes).map(c -> (ClassificationScopeSummary)((ClassificationScopeSummary.Builder)ClassificationScopeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListClassificationScopesResponse build() {
            return new ListClassificationScopesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClassificationScopesResponse> {
        public Builder classificationScopes(Collection<ClassificationScopeSummary> var1);

        public Builder classificationScopes(ClassificationScopeSummary ... var1);

        public Builder classificationScopes(Consumer<ClassificationScopeSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

