/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceProfileResponse extends Macie2Response implements
        ToCopyableBuilder<GetResourceProfileResponse.Builder, GetResourceProfileResponse> {
    private static final SdkField<Instant> PROFILE_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("profileUpdatedAt")
            .getter(getter(GetResourceProfileResponse::profileUpdatedAt))
            .setter(setter(Builder::profileUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> SENSITIVITY_SCORE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sensitivityScore").getter(getter(GetResourceProfileResponse::sensitivityScore))
            .setter(setter(Builder::sensitivityScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitivityScore").build()).build();

    private static final SdkField<Boolean> SENSITIVITY_SCORE_OVERRIDDEN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("sensitivityScoreOverridden")
            .getter(getter(GetResourceProfileResponse::sensitivityScoreOverridden))
            .setter(setter(Builder::sensitivityScoreOverridden))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitivityScoreOverridden").build())
            .build();

    private static final SdkField<ResourceStatistics> STATISTICS_FIELD = SdkField
            .<ResourceStatistics> builder(MarshallingType.SDK_POJO).memberName("statistics")
            .getter(getter(GetResourceProfileResponse::statistics)).setter(setter(Builder::statistics))
            .constructor(ResourceStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_UPDATED_AT_FIELD,
            SENSITIVITY_SCORE_FIELD, SENSITIVITY_SCORE_OVERRIDDEN_FIELD, STATISTICS_FIELD));

    private final Instant profileUpdatedAt;

    private final Integer sensitivityScore;

    private final Boolean sensitivityScoreOverridden;

    private final ResourceStatistics statistics;

    private GetResourceProfileResponse(BuilderImpl builder) {
        super(builder);
        this.profileUpdatedAt = builder.profileUpdatedAt;
        this.sensitivityScore = builder.sensitivityScore;
        this.sensitivityScoreOverridden = builder.sensitivityScoreOverridden;
        this.statistics = builder.statistics;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently recalculated sensitive
     * data discovery statistics and details for the bucket. If the bucket's sensitivity score is calculated
     * automatically, this includes the score.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently recalculated
     *         sensitive data discovery statistics and details for the bucket. If the bucket's sensitivity score is
     *         calculated automatically, this includes the score.
     */
    public final Instant profileUpdatedAt() {
        return profileUpdatedAt;
    }

    /**
     * <p>
     * The current sensitivity score for the bucket, ranging from -1 (classification error) to 100 (sensitive). By
     * default, this score is calculated automatically based on the amount of data that Amazon Macie has analyzed in the
     * bucket and the amount of sensitive data that Macie has found in the bucket.
     * </p>
     * 
     * @return The current sensitivity score for the bucket, ranging from -1 (classification error) to 100 (sensitive).
     *         By default, this score is calculated automatically based on the amount of data that Amazon Macie has
     *         analyzed in the bucket and the amount of sensitive data that Macie has found in the bucket.
     */
    public final Integer sensitivityScore() {
        return sensitivityScore;
    }

    /**
     * <p>
     * Specifies whether the bucket's current sensitivity score was set manually. If this value is true, the score was
     * manually changed to 100. If this value is false, the score was calculated automatically by Amazon Macie.
     * </p>
     * 
     * @return Specifies whether the bucket's current sensitivity score was set manually. If this value is true, the
     *         score was manually changed to 100. If this value is false, the score was calculated automatically by
     *         Amazon Macie.
     */
    public final Boolean sensitivityScoreOverridden() {
        return sensitivityScoreOverridden;
    }

    /**
     * <p>
     * The sensitive data discovery statistics for the bucket. The statistics capture the results of automated sensitive
     * data discovery activities that Amazon Macie has performed for the bucket.
     * </p>
     * 
     * @return The sensitive data discovery statistics for the bucket. The statistics capture the results of automated
     *         sensitive data discovery activities that Amazon Macie has performed for the bucket.
     */
    public final ResourceStatistics statistics() {
        return statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(sensitivityScore());
        hashCode = 31 * hashCode + Objects.hashCode(sensitivityScoreOverridden());
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceProfileResponse)) {
            return false;
        }
        GetResourceProfileResponse other = (GetResourceProfileResponse) obj;
        return Objects.equals(profileUpdatedAt(), other.profileUpdatedAt())
                && Objects.equals(sensitivityScore(), other.sensitivityScore())
                && Objects.equals(sensitivityScoreOverridden(), other.sensitivityScoreOverridden())
                && Objects.equals(statistics(), other.statistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceProfileResponse").add("ProfileUpdatedAt", profileUpdatedAt())
                .add("SensitivityScore", sensitivityScore()).add("SensitivityScoreOverridden", sensitivityScoreOverridden())
                .add("Statistics", statistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profileUpdatedAt":
            return Optional.ofNullable(clazz.cast(profileUpdatedAt()));
        case "sensitivityScore":
            return Optional.ofNullable(clazz.cast(sensitivityScore()));
        case "sensitivityScoreOverridden":
            return Optional.ofNullable(clazz.cast(sensitivityScoreOverridden()));
        case "statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceProfileResponse, T> g) {
        return obj -> g.apply((GetResourceProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceProfileResponse> {
        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently recalculated
         * sensitive data discovery statistics and details for the bucket. If the bucket's sensitivity score is
         * calculated automatically, this includes the score.
         * </p>
         * 
         * @param profileUpdatedAt
         *        The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently recalculated
         *        sensitive data discovery statistics and details for the bucket. If the bucket's sensitivity score is
         *        calculated automatically, this includes the score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileUpdatedAt(Instant profileUpdatedAt);

        /**
         * <p>
         * The current sensitivity score for the bucket, ranging from -1 (classification error) to 100 (sensitive). By
         * default, this score is calculated automatically based on the amount of data that Amazon Macie has analyzed in
         * the bucket and the amount of sensitive data that Macie has found in the bucket.
         * </p>
         * 
         * @param sensitivityScore
         *        The current sensitivity score for the bucket, ranging from -1 (classification error) to 100
         *        (sensitive). By default, this score is calculated automatically based on the amount of data that
         *        Amazon Macie has analyzed in the bucket and the amount of sensitive data that Macie has found in the
         *        bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitivityScore(Integer sensitivityScore);

        /**
         * <p>
         * Specifies whether the bucket's current sensitivity score was set manually. If this value is true, the score
         * was manually changed to 100. If this value is false, the score was calculated automatically by Amazon Macie.
         * </p>
         * 
         * @param sensitivityScoreOverridden
         *        Specifies whether the bucket's current sensitivity score was set manually. If this value is true, the
         *        score was manually changed to 100. If this value is false, the score was calculated automatically by
         *        Amazon Macie.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitivityScoreOverridden(Boolean sensitivityScoreOverridden);

        /**
         * <p>
         * The sensitive data discovery statistics for the bucket. The statistics capture the results of automated
         * sensitive data discovery activities that Amazon Macie has performed for the bucket.
         * </p>
         * 
         * @param statistics
         *        The sensitive data discovery statistics for the bucket. The statistics capture the results of
         *        automated sensitive data discovery activities that Amazon Macie has performed for the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(ResourceStatistics statistics);

        /**
         * <p>
         * The sensitive data discovery statistics for the bucket. The statistics capture the results of automated
         * sensitive data discovery activities that Amazon Macie has performed for the bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceStatistics.Builder} avoiding the
         * need to create one manually via {@link ResourceStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #statistics(ResourceStatistics)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link ResourceStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(ResourceStatistics)
         */
        default Builder statistics(Consumer<ResourceStatistics.Builder> statistics) {
            return statistics(ResourceStatistics.builder().applyMutation(statistics).build());
        }
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private Instant profileUpdatedAt;

        private Integer sensitivityScore;

        private Boolean sensitivityScoreOverridden;

        private ResourceStatistics statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceProfileResponse model) {
            super(model);
            profileUpdatedAt(model.profileUpdatedAt);
            sensitivityScore(model.sensitivityScore);
            sensitivityScoreOverridden(model.sensitivityScoreOverridden);
            statistics(model.statistics);
        }

        public final Instant getProfileUpdatedAt() {
            return profileUpdatedAt;
        }

        public final void setProfileUpdatedAt(Instant profileUpdatedAt) {
            this.profileUpdatedAt = profileUpdatedAt;
        }

        @Override
        public final Builder profileUpdatedAt(Instant profileUpdatedAt) {
            this.profileUpdatedAt = profileUpdatedAt;
            return this;
        }

        public final Integer getSensitivityScore() {
            return sensitivityScore;
        }

        public final void setSensitivityScore(Integer sensitivityScore) {
            this.sensitivityScore = sensitivityScore;
        }

        @Override
        public final Builder sensitivityScore(Integer sensitivityScore) {
            this.sensitivityScore = sensitivityScore;
            return this;
        }

        public final Boolean getSensitivityScoreOverridden() {
            return sensitivityScoreOverridden;
        }

        public final void setSensitivityScoreOverridden(Boolean sensitivityScoreOverridden) {
            this.sensitivityScoreOverridden = sensitivityScoreOverridden;
        }

        @Override
        public final Builder sensitivityScoreOverridden(Boolean sensitivityScoreOverridden) {
            this.sensitivityScoreOverridden = sensitivityScoreOverridden;
            return this;
        }

        public final ResourceStatistics.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        public final void setStatistics(ResourceStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(ResourceStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        @Override
        public GetResourceProfileResponse build() {
            return new GetResourceProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
