/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFindingsFilterResponse extends Macie2Response implements
        ToCopyableBuilder<GetFindingsFilterResponse.Builder, GetFindingsFilterResponse> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(GetFindingsFilterResponse::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetFindingsFilterResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetFindingsFilterResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<FindingCriteria> FINDING_CRITERIA_FIELD = SdkField
            .<FindingCriteria> builder(MarshallingType.SDK_POJO).memberName("findingCriteria")
            .getter(getter(GetFindingsFilterResponse::findingCriteria)).setter(setter(Builder::findingCriteria))
            .constructor(FindingCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingCriteria").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetFindingsFilterResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetFindingsFilterResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> POSITION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("position").getter(getter(GetFindingsFilterResponse::position)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetFindingsFilterResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ARN_FIELD,
            DESCRIPTION_FIELD, FINDING_CRITERIA_FIELD, ID_FIELD, NAME_FIELD, POSITION_FIELD, TAGS_FIELD));

    private final String action;

    private final String arn;

    private final String description;

    private final FindingCriteria findingCriteria;

    private final String id;

    private final String name;

    private final Integer position;

    private final Map<String, String> tags;

    private GetFindingsFilterResponse(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.arn = builder.arn;
        this.description = builder.description;
        this.findingCriteria = builder.findingCriteria;
        this.id = builder.id;
        this.name = builder.name;
        this.position = builder.position;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The action that's performed on findings that match the filter criteria (findingCriteria). Possible values are:
     * ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FindingsFilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action that's performed on findings that match the filter criteria (findingCriteria). Possible values
     *         are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the
     *         findings.
     * @see FindingsFilterAction
     */
    public final FindingsFilterAction action() {
        return FindingsFilterAction.fromValue(action);
    }

    /**
     * <p>
     * The action that's performed on findings that match the filter criteria (findingCriteria). Possible values are:
     * ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FindingsFilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action that's performed on findings that match the filter criteria (findingCriteria). Possible values
     *         are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the
     *         findings.
     * @see FindingsFilterAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the filter.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the filter.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The custom description of the filter.
     * </p>
     * 
     * @return The custom description of the filter.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The criteria that's used to filter findings.
     * </p>
     * 
     * @return The criteria that's used to filter findings.
     */
    public final FindingCriteria findingCriteria() {
        return findingCriteria;
    }

    /**
     * <p>
     * The unique identifier for the filter.
     * </p>
     * 
     * @return The unique identifier for the filter.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The custom name of the filter.
     * </p>
     * 
     * @return The custom name of the filter.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines
     * the order in which the filter is applied to findings, relative to other filters that are also applied to the
     * findings.
     * </p>
     * 
     * @return The position of the filter in the list of saved filters on the Amazon Macie console. This value also
     *         determines the order in which the filter is applied to findings, relative to other filters that are also
     *         applied to the findings.
     */
    public final Integer position() {
        return position;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that specifies which tags (keys and values) are associated with the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of key-value pairs that specifies which tags (keys and values) are associated with the filter.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(findingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsFilterResponse)) {
            return false;
        }
        GetFindingsFilterResponse other = (GetFindingsFilterResponse) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description())
                && Objects.equals(findingCriteria(), other.findingCriteria()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(position(), other.position())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFindingsFilterResponse").add("Action", actionAsString()).add("Arn", arn())
                .add("Description", description()).add("FindingCriteria", findingCriteria()).add("Id", id()).add("Name", name())
                .add("Position", position()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "findingCriteria":
            return Optional.ofNullable(clazz.cast(findingCriteria()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingsFilterResponse, T> g) {
        return obj -> g.apply((GetFindingsFilterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetFindingsFilterResponse> {
        /**
         * <p>
         * The action that's performed on findings that match the filter criteria (findingCriteria). Possible values
         * are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the
         * findings.
         * </p>
         * 
         * @param action
         *        The action that's performed on findings that match the filter criteria (findingCriteria). Possible
         *        values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any
         *        action on the findings.
         * @see FindingsFilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingsFilterAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action that's performed on findings that match the filter criteria (findingCriteria). Possible values
         * are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the
         * findings.
         * </p>
         * 
         * @param action
         *        The action that's performed on findings that match the filter criteria (findingCriteria). Possible
         *        values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any
         *        action on the findings.
         * @see FindingsFilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingsFilterAction
         */
        Builder action(FindingsFilterAction action);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the filter.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The custom description of the filter.
         * </p>
         * 
         * @param description
         *        The custom description of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The criteria that's used to filter findings.
         * </p>
         * 
         * @param findingCriteria
         *        The criteria that's used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingCriteria(FindingCriteria findingCriteria);

        /**
         * <p>
         * The criteria that's used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingCriteria.Builder} avoiding the
         * need to create one manually via {@link FindingCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #findingCriteria(FindingCriteria)}.
         * 
         * @param findingCriteria
         *        a consumer that will call methods on {@link FindingCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingCriteria(FindingCriteria)
         */
        default Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return findingCriteria(FindingCriteria.builder().applyMutation(findingCriteria).build());
        }

        /**
         * <p>
         * The unique identifier for the filter.
         * </p>
         * 
         * @param id
         *        The unique identifier for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The custom name of the filter.
         * </p>
         * 
         * @param name
         *        The custom name of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The position of the filter in the list of saved filters on the Amazon Macie console. This value also
         * determines the order in which the filter is applied to findings, relative to other filters that are also
         * applied to the findings.
         * </p>
         * 
         * @param position
         *        The position of the filter in the list of saved filters on the Amazon Macie console. This value also
         *        determines the order in which the filter is applied to findings, relative to other filters that are
         *        also applied to the findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Integer position);

        /**
         * <p>
         * A map of key-value pairs that specifies which tags (keys and values) are associated with the filter.
         * </p>
         * 
         * @param tags
         *        A map of key-value pairs that specifies which tags (keys and values) are associated with the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private String action;

        private String arn;

        private String description;

        private FindingCriteria findingCriteria;

        private String id;

        private String name;

        private Integer position;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsFilterResponse model) {
            super(model);
            action(model.action);
            arn(model.arn);
            description(model.description);
            findingCriteria(model.findingCriteria);
            id(model.id);
            name(model.name);
            position(model.position);
            tags(model.tags);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(FindingsFilterAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return findingCriteria != null ? findingCriteria.toBuilder() : null;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        @Override
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPosition() {
            return position;
        }

        public final void setPosition(Integer position) {
            this.position = position;
        }

        @Override
        public final Builder position(Integer position) {
            this.position = position;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetFindingsFilterResponse build() {
            return new GetFindingsFilterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
