/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the current status of an allow list, which indicates whether Amazon Macie can access and
 * use the list's criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllowListStatus implements SdkPojo, Serializable, ToCopyableBuilder<AllowListStatus.Builder, AllowListStatus> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(AllowListStatus::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AllowListStatus::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CODE_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String description;

    private AllowListStatus(BuilderImpl builder) {
        this.code = builder.code;
        this.description = builder.description;
    }

    /**
     * <p>
     * The current status of the allow list. If the list's criteria specify a regular expression (regex), this value is
     * typically OK. Amazon Macie can compile the expression.
     * </p>
     * <p>
     * If the list's criteria specify an S3 object, possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * OK - Macie can retrieve and parse the contents of the object.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3_OBJECT_ACCESS_DENIED - Macie isn't allowed to access the object or the object is encrypted with a customer
     * managed KMS key that Macie isn't allowed to use. Check the bucket policy and other permissions settings for the
     * bucket and the object. If the object is encrypted, also ensure that it's encrypted with a key that Macie is
     * allowed to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3_OBJECT_EMPTY - Macie can retrieve the object but the object doesn't contain any content. Ensure that the
     * object contains the correct entries. Also ensure that the list's criteria specify the correct bucket and object
     * names.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3_OBJECT_NOT_FOUND - The object doesn't exist in Amazon S3. Ensure that the list's criteria specify the correct
     * bucket and object names.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3_OBJECT_OVERSIZE - Macie can retrieve the object. However, the object contains too many entries or its storage
     * size exceeds the quota for an allow list. Try breaking the list into multiple files and ensure that each file
     * doesn't exceed any quotas. Then configure list settings in Macie for each file.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3_THROTTLED - Amazon S3 throttled the request to retrieve the object. Wait a few minutes and then try again.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3_USER_ACCESS_DENIED - Amazon S3 denied the request to retrieve the object. If the specified object exists,
     * you're not allowed to access it or it's encrypted with an KMS key that you're not allowed to use. Work with your
     * Amazon Web Services administrator to ensure that the list's criteria specify the correct bucket and object names,
     * and you have read access to the bucket and the object. If the object is encrypted, also ensure that it's
     * encrypted with a key that you're allowed to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN_ERROR - A transient or internal error occurred when Macie attempted to retrieve or parse the object. Wait
     * a few minutes and then try again. A list can also have this status if it's encrypted with a key that Amazon S3
     * and Macie can't access or use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link AllowListStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The current status of the allow list. If the list's criteria specify a regular expression (regex), this
     *         value is typically OK. Amazon Macie can compile the expression.</p>
     *         <p>
     *         If the list's criteria specify an S3 object, possible values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         OK - Macie can retrieve and parse the contents of the object.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3_OBJECT_ACCESS_DENIED - Macie isn't allowed to access the object or the object is encrypted with a
     *         customer managed KMS key that Macie isn't allowed to use. Check the bucket policy and other permissions
     *         settings for the bucket and the object. If the object is encrypted, also ensure that it's encrypted with
     *         a key that Macie is allowed to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3_OBJECT_EMPTY - Macie can retrieve the object but the object doesn't contain any content. Ensure that
     *         the object contains the correct entries. Also ensure that the list's criteria specify the correct bucket
     *         and object names.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3_OBJECT_NOT_FOUND - The object doesn't exist in Amazon S3. Ensure that the list's criteria specify the
     *         correct bucket and object names.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3_OBJECT_OVERSIZE - Macie can retrieve the object. However, the object contains too many entries or its
     *         storage size exceeds the quota for an allow list. Try breaking the list into multiple files and ensure
     *         that each file doesn't exceed any quotas. Then configure list settings in Macie for each file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3_THROTTLED - Amazon S3 throttled the request to retrieve the object. Wait a few minutes and then try
     *         again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3_USER_ACCESS_DENIED - Amazon S3 denied the request to retrieve the object. If the specified object
     *         exists, you're not allowed to access it or it's encrypted with an KMS key that you're not allowed to use.
     *         Work with your Amazon Web Services administrator to ensure that the list's criteria specify the correct
     *         bucket and object names, and you have read access to the bucket and the object. If the object is
     *         encrypted, also ensure that it's encrypted with a key that you're allowed to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN_ERROR - A transient or internal error occurred when Macie attempted to retrieve or parse the
     *         object. Wait a few minutes and then try again. A list can also have this status if it's encrypted with a
     *         key that Amazon S3 and Macie can't access or use.
     *         </p>
     *         </li>
     * @see AllowListStatusCode
     */
    public final AllowListStatusCode code() {
        return AllowListStatusCode.fromValue(code);
    }

    /**
     * <p>
     * The current status of the allow list. If the list's criteria specify a regular expression (regex), this value is
     * typically OK. Amazon Macie can compile the expression.
     * </p>
     * <p>
     * If the list's criteria specify an S3 object, possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * OK - Macie can retrieve and parse the contents of the object.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3_OBJECT_ACCESS_DENIED - Macie isn't allowed to access the object or the object is encrypted with a customer
     * managed KMS key that Macie isn't allowed to use. Check the bucket policy and other permissions settings for the
     * bucket and the object. If the object is encrypted, also ensure that it's encrypted with a key that Macie is
     * allowed to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3_OBJECT_EMPTY - Macie can retrieve the object but the object doesn't contain any content. Ensure that the
     * object contains the correct entries. Also ensure that the list's criteria specify the correct bucket and object
     * names.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3_OBJECT_NOT_FOUND - The object doesn't exist in Amazon S3. Ensure that the list's criteria specify the correct
     * bucket and object names.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3_OBJECT_OVERSIZE - Macie can retrieve the object. However, the object contains too many entries or its storage
     * size exceeds the quota for an allow list. Try breaking the list into multiple files and ensure that each file
     * doesn't exceed any quotas. Then configure list settings in Macie for each file.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3_THROTTLED - Amazon S3 throttled the request to retrieve the object. Wait a few minutes and then try again.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3_USER_ACCESS_DENIED - Amazon S3 denied the request to retrieve the object. If the specified object exists,
     * you're not allowed to access it or it's encrypted with an KMS key that you're not allowed to use. Work with your
     * Amazon Web Services administrator to ensure that the list's criteria specify the correct bucket and object names,
     * and you have read access to the bucket and the object. If the object is encrypted, also ensure that it's
     * encrypted with a key that you're allowed to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN_ERROR - A transient or internal error occurred when Macie attempted to retrieve or parse the object. Wait
     * a few minutes and then try again. A list can also have this status if it's encrypted with a key that Amazon S3
     * and Macie can't access or use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link AllowListStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The current status of the allow list. If the list's criteria specify a regular expression (regex), this
     *         value is typically OK. Amazon Macie can compile the expression.</p>
     *         <p>
     *         If the list's criteria specify an S3 object, possible values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         OK - Macie can retrieve and parse the contents of the object.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3_OBJECT_ACCESS_DENIED - Macie isn't allowed to access the object or the object is encrypted with a
     *         customer managed KMS key that Macie isn't allowed to use. Check the bucket policy and other permissions
     *         settings for the bucket and the object. If the object is encrypted, also ensure that it's encrypted with
     *         a key that Macie is allowed to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3_OBJECT_EMPTY - Macie can retrieve the object but the object doesn't contain any content. Ensure that
     *         the object contains the correct entries. Also ensure that the list's criteria specify the correct bucket
     *         and object names.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3_OBJECT_NOT_FOUND - The object doesn't exist in Amazon S3. Ensure that the list's criteria specify the
     *         correct bucket and object names.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3_OBJECT_OVERSIZE - Macie can retrieve the object. However, the object contains too many entries or its
     *         storage size exceeds the quota for an allow list. Try breaking the list into multiple files and ensure
     *         that each file doesn't exceed any quotas. Then configure list settings in Macie for each file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3_THROTTLED - Amazon S3 throttled the request to retrieve the object. Wait a few minutes and then try
     *         again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3_USER_ACCESS_DENIED - Amazon S3 denied the request to retrieve the object. If the specified object
     *         exists, you're not allowed to access it or it's encrypted with an KMS key that you're not allowed to use.
     *         Work with your Amazon Web Services administrator to ensure that the list's criteria specify the correct
     *         bucket and object names, and you have read access to the bucket and the object. If the object is
     *         encrypted, also ensure that it's encrypted with a key that you're allowed to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN_ERROR - A transient or internal error occurred when Macie attempted to retrieve or parse the
     *         object. Wait a few minutes and then try again. A list can also have this status if it's encrypted with a
     *         key that Amazon S3 and Macie can't access or use.
     *         </p>
     *         </li>
     * @see AllowListStatusCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * A brief description of the status of the allow list. Amazon Macie uses this value to provide additional
     * information about an error that occurred when Macie tried to access and use the list's criteria.
     * </p>
     * 
     * @return A brief description of the status of the allow list. Amazon Macie uses this value to provide additional
     *         information about an error that occurred when Macie tried to access and use the list's criteria.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowListStatus)) {
            return false;
        }
        AllowListStatus other = (AllowListStatus) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AllowListStatus").add("Code", codeAsString()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllowListStatus, T> g) {
        return obj -> g.apply((AllowListStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AllowListStatus> {
        /**
         * <p>
         * The current status of the allow list. If the list's criteria specify a regular expression (regex), this value
         * is typically OK. Amazon Macie can compile the expression.
         * </p>
         * <p>
         * If the list's criteria specify an S3 object, possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * OK - Macie can retrieve and parse the contents of the object.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_OBJECT_ACCESS_DENIED - Macie isn't allowed to access the object or the object is encrypted with a customer
         * managed KMS key that Macie isn't allowed to use. Check the bucket policy and other permissions settings for
         * the bucket and the object. If the object is encrypted, also ensure that it's encrypted with a key that Macie
         * is allowed to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_OBJECT_EMPTY - Macie can retrieve the object but the object doesn't contain any content. Ensure that the
         * object contains the correct entries. Also ensure that the list's criteria specify the correct bucket and
         * object names.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_OBJECT_NOT_FOUND - The object doesn't exist in Amazon S3. Ensure that the list's criteria specify the
         * correct bucket and object names.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_OBJECT_OVERSIZE - Macie can retrieve the object. However, the object contains too many entries or its
         * storage size exceeds the quota for an allow list. Try breaking the list into multiple files and ensure that
         * each file doesn't exceed any quotas. Then configure list settings in Macie for each file.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_THROTTLED - Amazon S3 throttled the request to retrieve the object. Wait a few minutes and then try again.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_USER_ACCESS_DENIED - Amazon S3 denied the request to retrieve the object. If the specified object exists,
         * you're not allowed to access it or it's encrypted with an KMS key that you're not allowed to use. Work with
         * your Amazon Web Services administrator to ensure that the list's criteria specify the correct bucket and
         * object names, and you have read access to the bucket and the object. If the object is encrypted, also ensure
         * that it's encrypted with a key that you're allowed to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN_ERROR - A transient or internal error occurred when Macie attempted to retrieve or parse the object.
         * Wait a few minutes and then try again. A list can also have this status if it's encrypted with a key that
         * Amazon S3 and Macie can't access or use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The current status of the allow list. If the list's criteria specify a regular expression (regex),
         *        this value is typically OK. Amazon Macie can compile the expression.</p>
         *        <p>
         *        If the list's criteria specify an S3 object, possible values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        OK - Macie can retrieve and parse the contents of the object.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_OBJECT_ACCESS_DENIED - Macie isn't allowed to access the object or the object is encrypted with a
         *        customer managed KMS key that Macie isn't allowed to use. Check the bucket policy and other
         *        permissions settings for the bucket and the object. If the object is encrypted, also ensure that it's
         *        encrypted with a key that Macie is allowed to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_OBJECT_EMPTY - Macie can retrieve the object but the object doesn't contain any content. Ensure
         *        that the object contains the correct entries. Also ensure that the list's criteria specify the correct
         *        bucket and object names.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_OBJECT_NOT_FOUND - The object doesn't exist in Amazon S3. Ensure that the list's criteria specify
         *        the correct bucket and object names.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_OBJECT_OVERSIZE - Macie can retrieve the object. However, the object contains too many entries or
         *        its storage size exceeds the quota for an allow list. Try breaking the list into multiple files and
         *        ensure that each file doesn't exceed any quotas. Then configure list settings in Macie for each file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_THROTTLED - Amazon S3 throttled the request to retrieve the object. Wait a few minutes and then try
         *        again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_USER_ACCESS_DENIED - Amazon S3 denied the request to retrieve the object. If the specified object
         *        exists, you're not allowed to access it or it's encrypted with an KMS key that you're not allowed to
         *        use. Work with your Amazon Web Services administrator to ensure that the list's criteria specify the
         *        correct bucket and object names, and you have read access to the bucket and the object. If the object
         *        is encrypted, also ensure that it's encrypted with a key that you're allowed to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN_ERROR - A transient or internal error occurred when Macie attempted to retrieve or parse the
         *        object. Wait a few minutes and then try again. A list can also have this status if it's encrypted with
         *        a key that Amazon S3 and Macie can't access or use.
         *        </p>
         *        </li>
         * @see AllowListStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowListStatusCode
         */
        Builder code(String code);

        /**
         * <p>
         * The current status of the allow list. If the list's criteria specify a regular expression (regex), this value
         * is typically OK. Amazon Macie can compile the expression.
         * </p>
         * <p>
         * If the list's criteria specify an S3 object, possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * OK - Macie can retrieve and parse the contents of the object.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_OBJECT_ACCESS_DENIED - Macie isn't allowed to access the object or the object is encrypted with a customer
         * managed KMS key that Macie isn't allowed to use. Check the bucket policy and other permissions settings for
         * the bucket and the object. If the object is encrypted, also ensure that it's encrypted with a key that Macie
         * is allowed to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_OBJECT_EMPTY - Macie can retrieve the object but the object doesn't contain any content. Ensure that the
         * object contains the correct entries. Also ensure that the list's criteria specify the correct bucket and
         * object names.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_OBJECT_NOT_FOUND - The object doesn't exist in Amazon S3. Ensure that the list's criteria specify the
         * correct bucket and object names.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_OBJECT_OVERSIZE - Macie can retrieve the object. However, the object contains too many entries or its
         * storage size exceeds the quota for an allow list. Try breaking the list into multiple files and ensure that
         * each file doesn't exceed any quotas. Then configure list settings in Macie for each file.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_THROTTLED - Amazon S3 throttled the request to retrieve the object. Wait a few minutes and then try again.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_USER_ACCESS_DENIED - Amazon S3 denied the request to retrieve the object. If the specified object exists,
         * you're not allowed to access it or it's encrypted with an KMS key that you're not allowed to use. Work with
         * your Amazon Web Services administrator to ensure that the list's criteria specify the correct bucket and
         * object names, and you have read access to the bucket and the object. If the object is encrypted, also ensure
         * that it's encrypted with a key that you're allowed to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN_ERROR - A transient or internal error occurred when Macie attempted to retrieve or parse the object.
         * Wait a few minutes and then try again. A list can also have this status if it's encrypted with a key that
         * Amazon S3 and Macie can't access or use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The current status of the allow list. If the list's criteria specify a regular expression (regex),
         *        this value is typically OK. Amazon Macie can compile the expression.</p>
         *        <p>
         *        If the list's criteria specify an S3 object, possible values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        OK - Macie can retrieve and parse the contents of the object.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_OBJECT_ACCESS_DENIED - Macie isn't allowed to access the object or the object is encrypted with a
         *        customer managed KMS key that Macie isn't allowed to use. Check the bucket policy and other
         *        permissions settings for the bucket and the object. If the object is encrypted, also ensure that it's
         *        encrypted with a key that Macie is allowed to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_OBJECT_EMPTY - Macie can retrieve the object but the object doesn't contain any content. Ensure
         *        that the object contains the correct entries. Also ensure that the list's criteria specify the correct
         *        bucket and object names.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_OBJECT_NOT_FOUND - The object doesn't exist in Amazon S3. Ensure that the list's criteria specify
         *        the correct bucket and object names.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_OBJECT_OVERSIZE - Macie can retrieve the object. However, the object contains too many entries or
         *        its storage size exceeds the quota for an allow list. Try breaking the list into multiple files and
         *        ensure that each file doesn't exceed any quotas. Then configure list settings in Macie for each file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_THROTTLED - Amazon S3 throttled the request to retrieve the object. Wait a few minutes and then try
         *        again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_USER_ACCESS_DENIED - Amazon S3 denied the request to retrieve the object. If the specified object
         *        exists, you're not allowed to access it or it's encrypted with an KMS key that you're not allowed to
         *        use. Work with your Amazon Web Services administrator to ensure that the list's criteria specify the
         *        correct bucket and object names, and you have read access to the bucket and the object. If the object
         *        is encrypted, also ensure that it's encrypted with a key that you're allowed to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN_ERROR - A transient or internal error occurred when Macie attempted to retrieve or parse the
         *        object. Wait a few minutes and then try again. A list can also have this status if it's encrypted with
         *        a key that Amazon S3 and Macie can't access or use.
         *        </p>
         *        </li>
         * @see AllowListStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowListStatusCode
         */
        Builder code(AllowListStatusCode code);

        /**
         * <p>
         * A brief description of the status of the allow list. Amazon Macie uses this value to provide additional
         * information about an error that occurred when Macie tried to access and use the list's criteria.
         * </p>
         * 
         * @param description
         *        A brief description of the status of the allow list. Amazon Macie uses this value to provide
         *        additional information about an error that occurred when Macie tried to access and use the list's
         *        criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(AllowListStatus model) {
            code(model.code);
            description(model.description);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(AllowListStatusCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public AllowListStatus build() {
            return new AllowListStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
