/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2AsyncClient;
import software.amazon.awssdk.services.macie2.model.ClassificationScopeSummary;
import software.amazon.awssdk.services.macie2.model.ListClassificationScopesRequest;
import software.amazon.awssdk.services.macie2.model.ListClassificationScopesResponse;

public class ListClassificationScopesPublisher
implements SdkPublisher<ListClassificationScopesResponse> {
    private final Macie2AsyncClient client;
    private final ListClassificationScopesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListClassificationScopesPublisher(Macie2AsyncClient client, ListClassificationScopesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListClassificationScopesPublisher(Macie2AsyncClient client, ListClassificationScopesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListClassificationScopesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListClassificationScopesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClassificationScopeSummary> classificationScopes() {
        Function<ListClassificationScopesResponse, Iterator> getIterator = response -> {
            if (response != null && response.classificationScopes() != null) {
                return response.classificationScopes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListClassificationScopesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListClassificationScopesResponseFetcher
    implements AsyncPageFetcher<ListClassificationScopesResponse> {
        private ListClassificationScopesResponseFetcher() {
        }

        public boolean hasNextPage(ListClassificationScopesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListClassificationScopesResponse> nextPage(ListClassificationScopesResponse previousPage) {
            if (previousPage == null) {
                return ListClassificationScopesPublisher.this.client.listClassificationScopes(ListClassificationScopesPublisher.this.firstRequest);
            }
            return ListClassificationScopesPublisher.this.client.listClassificationScopes((ListClassificationScopesRequest)((Object)ListClassificationScopesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

