/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplateExcludes;
import software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplateIncludes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSensitivityInspectionTemplateRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, UpdateSensitivityInspectionTemplateRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateSensitivityInspectionTemplateRequest.getter(UpdateSensitivityInspectionTemplateRequest::description)).setter(UpdateSensitivityInspectionTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<SensitivityInspectionTemplateExcludes> EXCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("excludes").getter(UpdateSensitivityInspectionTemplateRequest.getter(UpdateSensitivityInspectionTemplateRequest::excludes)).setter(UpdateSensitivityInspectionTemplateRequest.setter(Builder::excludes)).constructor(SensitivityInspectionTemplateExcludes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludes").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateSensitivityInspectionTemplateRequest.getter(UpdateSensitivityInspectionTemplateRequest::id)).setter(UpdateSensitivityInspectionTemplateRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<SensitivityInspectionTemplateIncludes> INCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("includes").getter(UpdateSensitivityInspectionTemplateRequest.getter(UpdateSensitivityInspectionTemplateRequest::includes)).setter(UpdateSensitivityInspectionTemplateRequest.setter(Builder::includes)).constructor(SensitivityInspectionTemplateIncludes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, EXCLUDES_FIELD, ID_FIELD, INCLUDES_FIELD));
    private final String description;
    private final SensitivityInspectionTemplateExcludes excludes;
    private final String id;
    private final SensitivityInspectionTemplateIncludes includes;

    private UpdateSensitivityInspectionTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.excludes = builder.excludes;
        this.id = builder.id;
        this.includes = builder.includes;
    }

    public final String description() {
        return this.description;
    }

    public final SensitivityInspectionTemplateExcludes excludes() {
        return this.excludes;
    }

    public final String id() {
        return this.id;
    }

    public final SensitivityInspectionTemplateIncludes includes() {
        return this.includes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludes());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.includes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSensitivityInspectionTemplateRequest)) {
            return false;
        }
        UpdateSensitivityInspectionTemplateRequest other = (UpdateSensitivityInspectionTemplateRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.excludes(), other.excludes()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.includes(), other.includes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSensitivityInspectionTemplateRequest").add("Description", (Object)this.description()).add("Excludes", (Object)this.excludes()).add("Id", (Object)this.id()).add("Includes", (Object)this.includes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "excludes": {
                return Optional.ofNullable(clazz.cast(this.excludes()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "includes": {
                return Optional.ofNullable(clazz.cast(this.includes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSensitivityInspectionTemplateRequest, T> g) {
        return obj -> g.apply((UpdateSensitivityInspectionTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private String description;
        private SensitivityInspectionTemplateExcludes excludes;
        private String id;
        private SensitivityInspectionTemplateIncludes includes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSensitivityInspectionTemplateRequest model) {
            super(model);
            this.description(model.description);
            this.excludes(model.excludes);
            this.id(model.id);
            this.includes(model.includes);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SensitivityInspectionTemplateExcludes.Builder getExcludes() {
            return this.excludes != null ? this.excludes.toBuilder() : null;
        }

        public final void setExcludes(SensitivityInspectionTemplateExcludes.BuilderImpl excludes) {
            this.excludes = excludes != null ? excludes.build() : null;
        }

        @Override
        public final Builder excludes(SensitivityInspectionTemplateExcludes excludes) {
            this.excludes = excludes;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final SensitivityInspectionTemplateIncludes.Builder getIncludes() {
            return this.includes != null ? this.includes.toBuilder() : null;
        }

        public final void setIncludes(SensitivityInspectionTemplateIncludes.BuilderImpl includes) {
            this.includes = includes != null ? includes.build() : null;
        }

        @Override
        public final Builder includes(SensitivityInspectionTemplateIncludes includes) {
            this.includes = includes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSensitivityInspectionTemplateRequest build() {
            return new UpdateSensitivityInspectionTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSensitivityInspectionTemplateRequest> {
        public Builder description(String var1);

        public Builder excludes(SensitivityInspectionTemplateExcludes var1);

        default public Builder excludes(Consumer<SensitivityInspectionTemplateExcludes.Builder> excludes) {
            return this.excludes((SensitivityInspectionTemplateExcludes)((SensitivityInspectionTemplateExcludes.Builder)SensitivityInspectionTemplateExcludes.builder().applyMutation(excludes)).build());
        }

        public Builder id(String var1);

        public Builder includes(SensitivityInspectionTemplateIncludes var1);

        default public Builder includes(Consumer<SensitivityInspectionTemplateIncludes.Builder> includes) {
            return this.includes((SensitivityInspectionTemplateIncludes)((SensitivityInspectionTemplateIncludes.Builder)SensitivityInspectionTemplateIncludes.builder().applyMutation(includes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

