/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.RelationshipStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Invitation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Invitation> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(Invitation.getter(Invitation::accountId)).setter(Invitation.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> INVITATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invitationId").getter(Invitation.getter(Invitation::invitationId)).setter(Invitation.setter(Builder::invitationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invitationId").build()}).build();
    private static final SdkField<Instant> INVITED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("invitedAt").getter(Invitation.getter(Invitation::invitedAt)).setter(Invitation.setter(Builder::invitedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invitedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> RELATIONSHIP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relationshipStatus").getter(Invitation.getter(Invitation::relationshipStatusAsString)).setter(Invitation.setter(Builder::relationshipStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationshipStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, INVITATION_ID_FIELD, INVITED_AT_FIELD, RELATIONSHIP_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String invitationId;
    private final Instant invitedAt;
    private final String relationshipStatus;

    private Invitation(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.invitationId = builder.invitationId;
        this.invitedAt = builder.invitedAt;
        this.relationshipStatus = builder.relationshipStatus;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String invitationId() {
        return this.invitationId;
    }

    public final Instant invitedAt() {
        return this.invitedAt;
    }

    public final RelationshipStatus relationshipStatus() {
        return RelationshipStatus.fromValue(this.relationshipStatus);
    }

    public final String relationshipStatusAsString() {
        return this.relationshipStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationshipStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Invitation)) {
            return false;
        }
        Invitation other = (Invitation)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.invitationId(), other.invitationId()) && Objects.equals(this.invitedAt(), other.invitedAt()) && Objects.equals(this.relationshipStatusAsString(), other.relationshipStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Invitation").add("AccountId", (Object)this.accountId()).add("InvitationId", (Object)this.invitationId()).add("InvitedAt", (Object)this.invitedAt()).add("RelationshipStatus", (Object)this.relationshipStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "invitationId": {
                return Optional.ofNullable(clazz.cast(this.invitationId()));
            }
            case "invitedAt": {
                return Optional.ofNullable(clazz.cast(this.invitedAt()));
            }
            case "relationshipStatus": {
                return Optional.ofNullable(clazz.cast(this.relationshipStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Invitation, T> g) {
        return obj -> g.apply((Invitation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String invitationId;
        private Instant invitedAt;
        private String relationshipStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Invitation model) {
            this.accountId(model.accountId);
            this.invitationId(model.invitationId);
            this.invitedAt(model.invitedAt);
            this.relationshipStatus(model.relationshipStatus);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getInvitationId() {
            return this.invitationId;
        }

        public final void setInvitationId(String invitationId) {
            this.invitationId = invitationId;
        }

        @Override
        @Transient
        public final Builder invitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        public final Instant getInvitedAt() {
            return this.invitedAt;
        }

        public final void setInvitedAt(Instant invitedAt) {
            this.invitedAt = invitedAt;
        }

        @Override
        @Transient
        public final Builder invitedAt(Instant invitedAt) {
            this.invitedAt = invitedAt;
            return this;
        }

        public final String getRelationshipStatus() {
            return this.relationshipStatus;
        }

        public final void setRelationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
        }

        @Override
        @Transient
        public final Builder relationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder relationshipStatus(RelationshipStatus relationshipStatus) {
            this.relationshipStatus(relationshipStatus == null ? null : relationshipStatus.toString());
            return this;
        }

        public Invitation build() {
            return new Invitation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Invitation> {
        public Builder accountId(String var1);

        public Builder invitationId(String var1);

        public Builder invitedAt(Instant var1);

        public Builder relationshipStatus(String var1);

        public Builder relationshipStatus(RelationshipStatus var1);
    }
}

