/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.JobComparator;
import software.amazon.awssdk.services.macie2.model.TagTarget;
import software.amazon.awssdk.services.macie2.model.TagValuePair;
import software.amazon.awssdk.services.macie2.model.___listOfTagValuePairCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TagScopeTerm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TagScopeTerm> {
    private static final SdkField<String> COMPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comparator").getter(TagScopeTerm.getter(TagScopeTerm::comparatorAsString)).setter(TagScopeTerm.setter(Builder::comparator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparator").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(TagScopeTerm.getter(TagScopeTerm::key)).setter(TagScopeTerm.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<List<TagValuePair>> TAG_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tagValues").getter(TagScopeTerm.getter(TagScopeTerm::tagValues)).setter(TagScopeTerm.setter(Builder::tagValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("target").getter(TagScopeTerm.getter(TagScopeTerm::targetAsString)).setter(TagScopeTerm.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARATOR_FIELD, KEY_FIELD, TAG_VALUES_FIELD, TARGET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comparator;
    private final String key;
    private final List<TagValuePair> tagValues;
    private final String target;

    private TagScopeTerm(BuilderImpl builder) {
        this.comparator = builder.comparator;
        this.key = builder.key;
        this.tagValues = builder.tagValues;
        this.target = builder.target;
    }

    public final JobComparator comparator() {
        return JobComparator.fromValue(this.comparator);
    }

    public final String comparatorAsString() {
        return this.comparator;
    }

    public final String key() {
        return this.key;
    }

    public final boolean hasTagValues() {
        return this.tagValues != null && !(this.tagValues instanceof SdkAutoConstructList);
    }

    public final List<TagValuePair> tagValues() {
        return this.tagValues;
    }

    public final TagTarget target() {
        return TagTarget.fromValue(this.target);
    }

    public final String targetAsString() {
        return this.target;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comparatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagValues() ? this.tagValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagScopeTerm)) {
            return false;
        }
        TagScopeTerm other = (TagScopeTerm)obj;
        return Objects.equals(this.comparatorAsString(), other.comparatorAsString()) && Objects.equals(this.key(), other.key()) && this.hasTagValues() == other.hasTagValues() && Objects.equals(this.tagValues(), other.tagValues()) && Objects.equals(this.targetAsString(), other.targetAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TagScopeTerm").add("Comparator", (Object)this.comparatorAsString()).add("Key", (Object)this.key()).add("TagValues", this.hasTagValues() ? this.tagValues() : null).add("Target", (Object)this.targetAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "comparator": {
                return Optional.ofNullable(clazz.cast(this.comparatorAsString()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "tagValues": {
                return Optional.ofNullable(clazz.cast(this.tagValues()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.targetAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TagScopeTerm, T> g) {
        return obj -> g.apply((TagScopeTerm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comparator;
        private String key;
        private List<TagValuePair> tagValues = DefaultSdkAutoConstructList.getInstance();
        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(TagScopeTerm model) {
            this.comparator(model.comparator);
            this.key(model.key);
            this.tagValues(model.tagValues);
            this.target(model.target);
        }

        public final String getComparator() {
            return this.comparator;
        }

        @Override
        public final Builder comparator(String comparator) {
            this.comparator = comparator;
            return this;
        }

        @Override
        public final Builder comparator(JobComparator comparator) {
            this.comparator(comparator == null ? null : comparator.toString());
            return this;
        }

        public final void setComparator(String comparator) {
            this.comparator = comparator;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final List<TagValuePair.Builder> getTagValues() {
            List<TagValuePair.Builder> result = ___listOfTagValuePairCopier.copyToBuilder(this.tagValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tagValues(Collection<TagValuePair> tagValues) {
            this.tagValues = ___listOfTagValuePairCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(TagValuePair ... tagValues) {
            this.tagValues(Arrays.asList(tagValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(Consumer<TagValuePair.Builder> ... tagValues) {
            this.tagValues(Stream.of(tagValues).map(c -> (TagValuePair)((TagValuePair.Builder)TagValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagValues(Collection<TagValuePair.BuilderImpl> tagValues) {
            this.tagValues = ___listOfTagValuePairCopier.copyFromBuilder(tagValues);
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public final Builder target(TagTarget target) {
            this.target(target == null ? null : target.toString());
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public TagScopeTerm build() {
            return new TagScopeTerm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TagScopeTerm> {
        public Builder comparator(String var1);

        public Builder comparator(JobComparator var1);

        public Builder key(String var1);

        public Builder tagValues(Collection<TagValuePair> var1);

        public Builder tagValues(TagValuePair ... var1);

        public Builder tagValues(Consumer<TagValuePair.Builder> ... var1);

        public Builder target(String var1);

        public Builder target(TagTarget var1);
    }
}

