/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFindingsResponse extends Macie2Response implements
        ToCopyableBuilder<ListFindingsResponse.Builder, ListFindingsResponse> {
    private static final SdkField<List<String>> FINDING_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("findingIds")
            .getter(getter(ListFindingsResponse::findingIds))
            .setter(setter(Builder::findingIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFindingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_IDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> findingIds;

    private final String nextToken;

    private ListFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.findingIds = builder.findingIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the FindingIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFindingIds() {
        return findingIds != null && !(findingIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings, where each string is the unique identifier for a finding that meets the filter criteria
     * specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFindingIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of strings, where each string is the unique identifier for a finding that meets the filter
     *         criteria specified in the request.
     */
    public final List<String> findingIds() {
        return findingIds;
    }

    /**
     * <p>
     * The string to use in a subsequent request to get the next page of results in a paginated response. This value is
     * null if there are no additional pages.
     * </p>
     * 
     * @return The string to use in a subsequent request to get the next page of results in a paginated response. This
     *         value is null if there are no additional pages.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingIds() ? findingIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsResponse)) {
            return false;
        }
        ListFindingsResponse other = (ListFindingsResponse) obj;
        return hasFindingIds() == other.hasFindingIds() && Objects.equals(findingIds(), other.findingIds())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFindingsResponse").add("FindingIds", hasFindingIds() ? findingIds() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingIds":
            return Optional.ofNullable(clazz.cast(findingIds()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingsResponse, T> g) {
        return obj -> g.apply((ListFindingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListFindingsResponse> {
        /**
         * <p>
         * An array of strings, where each string is the unique identifier for a finding that meets the filter criteria
         * specified in the request.
         * </p>
         * 
         * @param findingIds
         *        An array of strings, where each string is the unique identifier for a finding that meets the filter
         *        criteria specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIds(Collection<String> findingIds);

        /**
         * <p>
         * An array of strings, where each string is the unique identifier for a finding that meets the filter criteria
         * specified in the request.
         * </p>
         * 
         * @param findingIds
         *        An array of strings, where each string is the unique identifier for a finding that meets the filter
         *        criteria specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIds(String... findingIds);

        /**
         * <p>
         * The string to use in a subsequent request to get the next page of results in a paginated response. This value
         * is null if there are no additional pages.
         * </p>
         * 
         * @param nextToken
         *        The string to use in a subsequent request to get the next page of results in a paginated response.
         *        This value is null if there are no additional pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private List<String> findingIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsResponse model) {
            super(model);
            findingIds(model.findingIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getFindingIds() {
            if (findingIds instanceof SdkAutoConstructList) {
                return null;
            }
            return findingIds;
        }

        @Override
        public final Builder findingIds(Collection<String> findingIds) {
            this.findingIds = ___listOf__stringCopier.copy(findingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIds(String... findingIds) {
            findingIds(Arrays.asList(findingIds));
            return this;
        }

        public final void setFindingIds(Collection<String> findingIds) {
            this.findingIds = ___listOf__stringCopier.copy(findingIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFindingsResponse build() {
            return new ListFindingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
